/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.resource;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.infrastructure.ChildrenManager;
import eu.emi.emir.infrastructure.EmptyIdentifierFailureException;
import eu.emi.emir.infrastructure.NullPointerFailureException;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;

@Path(value="/children")
public class ChildrenResource {
    private static final Logger logger = Log.getLogger((String)"emir.httpserver", ChildrenResource.class);

    @POST
    public Response checkin(@Context UriInfo infos) {
        logger.debug((Object)"checkin !!");
        try {
            if (ChildrenManager.getInstance().addChildDSR(this.extractServiceUrlFromUri(infos))) {
                return Response.ok().entity((Object)new String("First registration")).build();
            }
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No endpoint given!").build();
        }
        catch (EmptyIdentifierFailureException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Empty endpoint given!").build();
        }
        catch (NullPointerFailureException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No endpoint given!").build();
        }
        return Response.ok().build();
    }

    @GET
    public Response childDSRs() {
        List<String> resp;
        logger.debug((Object)"checkout !!");
        try {
            resp = ChildrenManager.getInstance().getChildDSRs();
        }
        catch (ConcurrentModificationException e) {
            resp = ChildrenManager.getInstance().getChildDSRs();
        }
        JSONArray respArray = new JSONArray();
        for (int i = 0; i < resp.size(); ++i) {
            logger.debug((Object)(i + ". value: " + resp.get(i)));
            respArray.put((Object)resp.get(i));
        }
        return Response.ok().entity((Object)respArray).build();
    }

    private String extractServiceUrlFromUri(UriInfo infos) throws IllegalArgumentException {
        String attrName;
        String key;
        MultivaluedMap mm = infos.getQueryParameters();
        String string = key = mm.containsKey((Object)(attrName = ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName())) ? attrName : "unknown";
        if (key == "unknown") {
            throw new IllegalArgumentException();
        }
        String value = (String)mm.getFirst((Object)ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName());
        return value;
    }
}

