/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.pdp.local;

import eu.emi.emir.client.util.Log;
import eu.emi.emir.pdp.PDPUtils;
import eu.emi.emir.security.Client;
import eu.emi.emir.security.XACMLAttribute;
import eu.emi.emir.security.util.ResourceDescriptor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.impl.ActionType;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.EnvironmentType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.herasaf.xacml.core.converter.URNToDataTypeConverter;
import org.herasaf.xacml.core.dataTypeAttribute.DataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.AnyURIDataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.StringDataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.X500DataTypeAttribute;

public class RequestCreator {
    private static final Logger log = Log.getLogger((String)"emir.security", RequestCreator.class);

    public RequestCtx createRequest(Client c, String action, ResourceDescriptor des) {
        X509Certificate consignorCert;
        RequestType req = new RequestType();
        List subjects = req.getSubjects();
        SubjectType subject = new SubjectType();
        subjects.add(subject);
        List subjectAttrs = subject.getAttributes();
        PDPUtils.validateClient(c);
        AttributeType idAttribute = RequestCreator.getAttribute(XACMLAttribute.Name.XACML_SUBJECT_ID_ATTR.toString(), new X500DataTypeAttribute(), new X500Principal(c.getDistinguishedName()).getName());
        subjectAttrs.add(idAttribute);
        AttributeType roleAttribute = RequestCreator.getAttribute("role", new StringDataTypeAttribute(), c.getRole().getName());
        subjectAttrs.add(roleAttribute);
        if (c.getSecurityTokens() != null && (consignorCert = c.getSecurityTokens().getConsignorCertificate()) != null) {
            AttributeType consignorAttribute = RequestCreator.getAttribute("consignor", new X500DataTypeAttribute(), consignorCert.getSubjectX500Principal().getName());
            subjectAttrs.add(consignorAttribute);
        }
        this.addAttributesFromAIPs(c, subjectAttrs);
        List resources = req.getResources();
        ResourceType resource = new ResourceType();
        resources.add(resource);
        List resourceAttrs = resource.getAttributes();
        AttributeType resourceIdAttr = RequestCreator.getAttribute(XACMLAttribute.Name.XACML_RESOURCE_ID_ATTR.toString(), new AnyURIDataTypeAttribute(), des.getServiceName());
        resourceAttrs.add(resourceIdAttr);
        if (des.getResourceID() != null) {
            AttributeType wsrResourceIdAttr = RequestCreator.getAttribute("urn:unicore:wsresource", new StringDataTypeAttribute(), des.getResourceID());
            resourceAttrs.add(wsrResourceIdAttr);
        }
        if (des.getOwner() != null) {
            AttributeType ownerAttribute = RequestCreator.getAttribute("owner", new X500DataTypeAttribute(), new X500Principal(des.getOwner()).getName());
            resourceAttrs.add(ownerAttribute);
        }
        if (action != null) {
            ActionType xacmlAction = new ActionType();
            List actionAttrs = xacmlAction.getAttributes();
            AttributeType actionIdAttr = RequestCreator.getAttribute(XACMLAttribute.Name.XACML_ACTION_ID_ATTR.toString(), new StringDataTypeAttribute(), action);
            actionAttrs.add(actionIdAttr);
            req.setAction(xacmlAction);
        }
        EnvironmentType env = new EnvironmentType();
        req.setEnvironment(env);
        RequestCtx ret = new RequestCtx(req);
        return ret;
    }

    private static AttributeValueType getStringAV(String val) {
        AttributeValueType ret = new AttributeValueType();
        ret.getContent().add(val);
        return ret;
    }

    private static AttributeType getAttribute(String id, DataTypeAttribute<?> type, String value) {
        AttributeType attribute = new AttributeType();
        attribute.setAttributeId(id);
        attribute.setDataType(type);
        attribute.getAttributeValues().add(RequestCreator.getStringAV(value));
        return attribute;
    }

    private void addAttributesFromAIPs(Client client, List<AttributeType> subjectAttrs) {
        URNToDataTypeConverter converter = new URNToDataTypeConverter();
        for (XACMLAttribute attr : client.getSubjectAttributes().getXacmlAttributes()) {
            if (!PDPUtils.checkGenericAttr(attr.getName())) {
                log.warn((Object)("Among clients GENERIC XACML attributes retrieved from the configured attribute sources, the special attribute " + attr.getName() + " was found. Ignoring it."));
                continue;
            }
            AttributeType herasfAttribute = RequestCreator.getAttribute(attr.getName(), converter.unmarshal(attr.getType().toString()), attr.getValue());
            subjectAttrs.add(herasfAttribute);
        }
    }
}

