/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.RegistryThreadPool;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.event.Event;
import eu.emi.emir.p2p.NeighborsEventReciever;
import eu.emi.emir.p2p.RemoveCheck;
import eu.emi.emir.p2p.SelfRegistration;
import eu.emi.emir.p2p.ServiceEventReceiver;
import eu.emi.emir.p2p.ValidityCheck;
import org.apache.log4j.Logger;

public class StartStopMethods {
    private static Logger logger = Log.getLogger((String)"emir.core", StartStopMethods.class);
    private static String myURL = "";

    public static void startGSRFunctions() {
        int timedelay;
        RegistryThreadPool.getExecutorService().execute(new NeighborsEventReciever());
        RegistryThreadPool.getExecutorService().execute(new ServiceEventReceiver());
        myURL = EMIRServer.getServerProperties().getValue("address");
        StartStopMethods.deleteOwnEntry();
        try {
            RegistryThreadPool.getExecutorService().execute(new SelfRegistration(myURL));
        }
        catch (Throwable e) {
            logger.warn((Object)"Has a problem with the self-registration.");
        }
        try {
            timedelay = EMIRServer.getServerProperties().getIntValue("global.softStateDelay");
            if (timedelay < 0) {
                logger.info((Object)("Configured Soft-State timedelay value (" + timedelay + ") is very low. Min value: 0 Default value (2 hours) will be used."));
                timedelay = 2;
            }
            logger.info((Object)("Set the Soft-State timedelay to " + timedelay));
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Set the default (2 hours) value of Soft-State timedelay.");
            timedelay = 2;
        }
        try {
            RegistryThreadPool.getExecutorService().execute(new ValidityCheck(timedelay));
        }
        catch (Throwable e) {
            logger.warn((Object)"Has a problem with the validity check.");
        }
        try {
            RegistryThreadPool.getExecutorService().execute(new RemoveCheck(timedelay));
        }
        catch (Throwable e) {
            logger.warn((Object)"Has a problem with the remove check.");
        }
    }

    public static void stopGSRFunctions() {
        System.out.println("Send DELETE message to the neighbors.");
        logger.info((Object)"Send DELETE message to the neighbors.");
        Event event = new Event("service_delete", myURL);
        new ServiceEventReceiver().recieve(event);
        StartStopMethods.deleteOwnEntry();
    }

    private static void deleteOwnEntry() {
        try {
            new MongoDBServiceDatabase().deleteByEndpointID(myURL);
        }
        catch (Exception e) {
            Log.logException((String)"Error in the delete procedure ", (Throwable)e);
        }
    }
}

