/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.event.Event;
import eu.emi.emir.event.EventDispatcher;
import eu.emi.emir.event.EventListener;
import eu.emi.emir.infrastructure.Filters;
import eu.emi.emir.p2p.MessageSendInThread;
import eu.emi.emir.p2p.NeighborsManager;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class ServiceEventReceiver
implements EventListener,
Runnable {
    private static Logger logger = Log.getLogger((String)"emir.core", ServiceEventReceiver.class);
    private Filters filter = new Filters();
    private String myURL = EMIRServer.getServerProperties().getValue("address");

    @Override
    public void recieve(Event event) {
        JSONArray jos;
        List<String> neighbors;
        block8: {
            neighbors = NeighborsManager.getInstance().getNeighbors();
            if (neighbors.size() == 1 && neighbors.get(0).equals(this.myURL)) {
                return;
            }
            jos = new JSONArray();
            try {
                jos = this.filter.outputFilter((JSONArray)event.getData());
                if (jos.length() == 0) {
                    return;
                }
            }
            catch (ClassCastException e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)"event.data to JSONArray cast problem. May be delete message.");
            }
        }
        String eventType = null;
        if (event.getType().equalsIgnoreCase("service_add")) {
            eventType = "add";
        }
        if (event.getType().equalsIgnoreCase("service_update")) {
            eventType = "update";
        }
        if (event.getType().equalsIgnoreCase("service_delete")) {
            eventType = "delete";
            jos.put((Object)((JSONObject)event.getData()));
        }
        int retry = NeighborsManager.getInstance().getRetry();
        for (int i = 0; i < neighbors.size(); ++i) {
            new MessageSendInThread(neighbors.get(i), retry, jos, eventType, event);
        }
    }

    @Override
    public void run() {
        EventDispatcher.add(this);
    }
}

