/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import com.mongodb.MongoException;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RemoveCheck
implements Runnable {
    private static Logger logger = Log.getLogger((String)"emir.core", RemoveCheck.class);
    private int etremove;
    private int timedelay;
    private MongoDBServiceDatabase mongoDB;

    public RemoveCheck(int delay) {
        this.timedelay = delay;
        this.mongoDB = new MongoDBServiceDatabase();
        try {
            this.etremove = EMIRServer.getServerProperties().getIntValue("global.etRemove");
            if (this.etremove < 24) {
                logger.info((Object)("Configured etremove value (" + this.etremove + ") is very low. Min value: 24 Default value will be used."));
                this.etremove = 24;
            }
            logger.info((Object)("Set the etremove to " + this.etremove));
        }
        catch (NumberFormatException e) {
            logger.info((Object)"Set the default (24hours) value of etremove.");
            this.etremove = 24;
        }
    }

    @Override
    public void run() {
        String query = "{ $and: [ { $and: [ { Service_Endpoint_ID : { $exists : true } }, { updateSince : { $exists : true } } ] },{ $and: [ { Service_CreationTime : { $exists : false } }, { Service_ExpireOn : { $exists : false } } ] }] }";
        while (true) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Soft-State thread (remove) started");
            }
            JSONObject currentTime = DateUtil.setExpiryTimeWithHours((JSONObject)new JSONObject(), (Integer)this.timedelay);
            try {
                String extendedQuery = "{ $and: [ ";
                extendedQuery = extendedQuery + query;
                extendedQuery = extendedQuery + ", { \"updateSince\" : { $lt: " + currentTime.getString("Service_ExpireOn") + "} }";
                extendedQuery = extendedQuery + "] }";
                logger.info((Object)extendedQuery);
                this.mongoDB.findAndDelete(query);
            }
            catch (MongoException e) {
                logger.warn((Object)e.getCause());
            }
            catch (JSONException e) {
                logger.warn((Object)e.getCause());
            }
            try {
                Thread.sleep(this.etremove * 60 * 60 * 1000);
                continue;
            }
            catch (InterruptedException e) {
                Log.logException((String)"", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

