/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.p2p;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.event.Event;
import eu.emi.emir.p2p.NeighborsManager;
import eu.unicore.util.httpclient.IClientConfiguration;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class MessageSendInThread
extends Thread {
    private static Logger logger = Log.getLogger((String)"emir.core", MessageSendInThread.class);
    private int retry;
    private String neighbor;
    private JSONArray message;
    private String eventType;
    private Event event;
    private WebResource client;

    public MessageSendInThread(String neighbor_, int retry_, JSONArray message_, String eventType_, Event event_) {
        super(neighbor_);
        this.retry = retry_;
        this.neighbor = neighbor_;
        this.message = message_;
        this.eventType = eventType_;
        this.event = event_;
        this.client = null;
        this.start();
    }

    @Override
    public void run() {
        boolean connected = true;
        for (int count = 0; count < this.retry; ++count) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Send service " + this.eventType + " message to " + this.neighbor + " " + (count + 1) + " time(s)."));
                }
                this.messageSend(this.neighbor, this.message, this.event.getType());
                connected = true;
                break;
            }
            catch (ClientHandlerException e) {
                connected = false;
                continue;
            }
        }
        if (!connected) {
            NeighborsManager.getInstance().setUnavailableNeighbor(this.neighbor);
        } else {
            NeighborsManager.getInstance().resetUnavailableNeighbor(this.neighbor);
        }
    }

    private void messageSend(String url, JSONArray message, String method) throws ClientHandlerException {
        this.client = this.getClient(url);
        ClientResponse res = null;
        if (method.equals("service_add")) {
            res = (ClientResponse)this.client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ClientResponse.class, (Object)message);
        }
        if (method.equals("service_update")) {
            res = (ClientResponse)this.client.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)message);
        }
        if (method.equals("service_delete")) {
            try {
                String deleteEndpointID = message.getJSONObject(0).getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName());
                String updateSince = ((JSONObject)message.getJSONObject(0).get("updateSince")).getString("$date");
                res = (ClientResponse)this.client.queryParam(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), deleteEndpointID).queryParam(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName(), updateSince).delete(ClientResponse.class);
            }
            catch (JSONException e) {
                logger.warn((Object)e.getCause());
            }
        }
        if (res.getStatus() == ClientResponse.Status.OK.getStatusCode() || res.getStatus() == ClientResponse.Status.CONFLICT.getStatusCode()) {
            logger.info((Object)("(" + this.eventType + ") Message sent succesfully to " + url));
        } else if (res.getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
            logger.info((Object)("Does not have access for the following neighbors: " + url));
        }
    }

    protected WebResource getClient(String url) {
        EMIRClient c = new EMIRClient(url + "/serviceadmin");
        if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
            c = new EMIRClient(url + "/serviceadmin", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
        }
        return c.getClientResource();
    }
}

