/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.infrastructure;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.ServiceDatabase;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.infrastructure.Filters;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ServiceCheckin
implements Runnable {
    private static Logger logger = Log.getLogger((String)"emir.core", ServiceCheckin.class);
    private final WebResource childClient;
    private final WebResource synchClient;
    private String myURL;
    private String parentURL;
    private Long max;
    private ServiceDatabase serviceDB;
    private Filters filters;

    public ServiceCheckin(String parentUrl, String url, Long maxmessage) throws Throwable {
        String slash = "/";
        if (parentUrl.charAt(parentUrl.length() - 1) == '/') {
            slash = "";
        }
        this.parentURL = parentUrl;
        EMIRClient cc = new EMIRClient(parentUrl + slash + "children");
        EMIRClient sc = new EMIRClient(parentUrl + slash + "serviceadmin");
        if (EMIRServer.getServerSecurityProperties().isSslEnabled()) {
            cc = new EMIRClient(parentUrl + slash + "children", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
            sc = new EMIRClient(parentUrl + slash + "serviceadmin", (IClientConfiguration)EMIRServer.getClientSecurityProperties());
        }
        this.childClient = cc.getClientResource();
        this.synchClient = sc.getClientResource();
        this.serviceDB = new MongoDBServiceDatabase();
        try {
            URL tmp = new URL(url);
            if (tmp.getProtocol().isEmpty()) {
                logger.error((Object)"The registry.scheme element is empty in the configuration!");
                this.finalize();
            }
            if (tmp.getHost().isEmpty()) {
                logger.error((Object)"The registry.hostname element is empty in the configuration!");
                this.finalize();
            }
            if (tmp.getHost().equals("localhost")) {
                logger.error((Object)"You added 'localhost' value in the registry.hostname element. Please modified it to the real DNS name or IP address!");
                this.finalize();
            }
            if (tmp.getPort() == -1) {
                logger.error((Object)"The registry.post element is empty in the configuration!");
                this.finalize();
            }
        }
        catch (MalformedURLException e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
        }
        this.myURL = url;
        this.max = maxmessage;
        this.filters = new Filters();
    }

    @Override
    public void run() {
        String refID = null;
        while (true) {
            logger.debug((Object)"checkin service entry");
            try {
                ClientResponse res = (ClientResponse)this.childClient.queryParam(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName(), this.myURL).post(ClientResponse.class);
                if (res.getStatus() == Response.Status.BAD_REQUEST.getStatusCode() || res.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    logger.error((Object)("Please modified the server's configuration, because the following error (" + (String)res.getEntity(String.class) + ") given from the parent DSR. Checkin stopped!"));
                    return;
                }
                if (res.hasEntity() && (((String)res.getEntity(String.class)).equals("First registration") || refID != null)) {
                    try {
                        JSONArray message = this.serviceDB.paginatedQuery("{}", this.max.intValue(), refID, ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName());
                        logger.debug((Object)("Synchronisation STARTED with the parent EMIR: " + this.parentURL));
                        while (message.length() > 0) {
                            logger.trace((Object)("Send SYNCH message with reference DB record ID _id: " + refID + ", to the parent: " + this.parentURL));
                            message = this.convert(message);
                            this.synchClient.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ClientResponse.class, (Object)this.filters.outputFilter(message));
                            JSONObject doc = new JSONObject(message.get(message.length() - 1).toString());
                            refID = doc.getJSONObject("_id").get("$oid").toString();
                            message = this.serviceDB.paginatedQuery("{}", this.max.intValue(), refID, ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName());
                        }
                        refID = null;
                        logger.debug((Object)("Synchronisation FINISHED with the parent EMIR: " + this.parentURL));
                    }
                    catch (JSONException e) {
                        Log.logException((String)"", (Throwable)e, (Logger)logger);
                    }
                }
            }
            catch (ClientHandlerException e) {
                logger.info((Object)"The parent DSR is not available.");
            }
            try {
                Thread.sleep(3600000L);
                continue;
            }
            catch (InterruptedException e) {
                Log.logException((String)"", (Throwable)e, (Logger)logger);
                continue;
            }
            break;
        }
    }

    private JSONArray convert(JSONArray array) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.length(); ++i) {
            try {
                result.put((Object)new JSONObject(array.getString(i)));
                continue;
            }
            catch (JSONException e) {
                Log.logException((String)"JSONObject convertation problem: ", (Throwable)e, (Logger)logger);
            }
        }
        return result;
    }
}

