/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.infrastructure;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.util.Log;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Filters {
    private static Logger logger = Log.getLogger((String)"emir.core", Filters.class);
    private HashMap<String, List<String>> inputfilters;
    private HashMap<String, List<String>> outputfilters;
    private String inputFilterPath = EMIRServer.getServerProperties().getValue("record.blockList.incoming");
    private long lastModificationInput;
    private String outputFilterPath = EMIRServer.getServerProperties().getValue("record.blockList.outgoing");
    private long lastModificationOutput;

    public JSONArray inputFilter(JSONArray serviceInfos) {
        if (this.inputFilterPath == null) {
            logger.warn((Object)"registry.filters.input file path is empty in the configuration! Input filter turned OFF!");
            return serviceInfos;
        }
        return this.filter(serviceInfos, this.inputFilterPath, this.inputfilters);
    }

    public JSONArray outputFilter(JSONArray serviceInfos) {
        if (this.outputFilterPath == null) {
            logger.warn((Object)"registry.filters.output file path is empty in the configuration! Output filter turned OFF!");
            return serviceInfos;
        }
        return this.filter(serviceInfos, this.outputFilterPath, this.outputfilters);
    }

    private JSONArray filter(JSONArray serviceInfos, String path, HashMap<String, List<String>> filters) {
        long lastModification = new File(path).lastModified();
        if (filters == null) {
            filters = this.loadFromFile(path);
            if (path.equals(this.inputFilterPath)) {
                this.inputfilters = filters;
                this.lastModificationInput = lastModification;
            } else {
                this.outputfilters = filters;
                this.lastModificationOutput = lastModification;
            }
        }
        if (path.equals(this.inputFilterPath) && this.lastModificationInput < lastModification) {
            filters.clear();
            this.inputfilters = this.loadFromFile(path);
            filters = this.inputfilters;
            this.lastModificationInput = lastModification;
            logger.debug((Object)"Input filters updated!");
        }
        if (path.equals(this.outputFilterPath) && this.lastModificationOutput < lastModification) {
            filters.clear();
            this.outputfilters = this.loadFromFile(path);
            filters = this.outputfilters;
            this.lastModificationOutput = lastModification;
            logger.debug((Object)"Output filters updated!");
        }
        JSONArray filteredArray = new JSONArray();
        Set<Map.Entry<String, List<String>>> s = filters.entrySet();
        for (int i = 0; i < serviceInfos.length(); ++i) {
            boolean found = false;
            for (Map.Entry<String, List<String>> m : s) {
                try {
                    if (!serviceInfos.getJSONObject(i).has(m.getKey()) || !this.valueMatch(serviceInfos.getJSONObject(i), m)) continue;
                    found = true;
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Positive " + (path.equals(this.inputFilterPath) ? "input" : "output") + " filter matching!  " + "Service_Endpoint_ID: " + serviceInfos.getJSONObject(i).getString("Service_Endpoint_ID") + ", Name of attribute: " + m.getKey() + ", Value: " + serviceInfos.getJSONObject(i).getString(m.getKey())));
                    break;
                }
                catch (JSONException e) {
                    Log.logException((String)"", (Throwable)e);
                }
            }
            if (found) continue;
            try {
                filteredArray.put((Object)serviceInfos.getJSONObject(i));
                continue;
            }
            catch (JSONException e) {
                Log.logException((String)"", (Throwable)e);
            }
        }
        return filteredArray;
    }

    private HashMap<String, List<String>> loadFromFile(String path) {
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String delimiter = "=";
            while ((strLine = br.readLine()) != null) {
                String[] temp;
                if (strLine.trim().substring(0, 1).endsWith("#") || (temp = strLine.replaceAll(" ", "").split(delimiter, 2)).length != 2) continue;
                List<Object> values = new ArrayList();
                if (filters.containsKey(temp[0])) {
                    values = filters.get(temp[0]);
                }
                if (values.contains(temp[1])) continue;
                values.add(temp[1]);
                filters.put(temp[0], values);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)("Filter file (" + path + ") not found! " + (path.equals(this.inputFilterPath) ? "Input" : "Output") + " filter turned OFF!"));
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsed filters: " + filters.toString()));
        }
        return filters;
    }

    private boolean valueMatch(JSONObject entry, Map.Entry m) {
        block15: {
            int i;
            JSONArray entryValues;
            block14: {
                block13: {
                    try {
                        if (((List)m.getValue()).contains(entry.getString((String)m.getKey()))) {
                            return true;
                        }
                    }
                    catch (JSONException e) {
                        if (!logger.isDebugEnabled()) break block13;
                        logger.warn((Object)("entry.getString trow exception in the valueMatch function: " + (Object)((Object)e)));
                    }
                }
                try {
                    entryValues = (JSONArray)entry.get((String)m.getKey());
                    for (i = 0; i < entryValues.length(); ++i) {
                        if (!((List)m.getValue()).contains(entryValues.getJSONObject(i).toString())) continue;
                        return true;
                    }
                }
                catch (JSONException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("This key (" + (String)m.getKey() + ") not exist in this entry or the values of JSONArray are not JSONObject."));
                    }
                }
                catch (ClassCastException e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)("The value (" + (String)m.getKey() + ") was not JSONArray."));
                }
            }
            try {
                entryValues = (JSONArray)entry.get((String)m.getKey());
                for (i = 0; i < entryValues.length(); ++i) {
                    if (!((List)m.getValue()).contains(entryValues.get(i).toString())) continue;
                    return true;
                }
            }
            catch (JSONException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("This key(" + (String)m.getKey() + ") not exist in this entry."));
                }
            }
            catch (ClassCastException e) {
                if (!logger.isDebugEnabled()) break block15;
                logger.debug((Object)("The value (" + (String)m.getKey() + ") was not simple Array."));
            }
        }
        return false;
    }
}

