/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.db.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.JSON;
import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.ExistingResourceException;
import eu.emi.emir.db.MultipleResourceException;
import eu.emi.emir.db.NonExistingResourceException;
import eu.emi.emir.db.PersistentStoreFailureException;
import eu.emi.emir.db.QueryException;
import eu.emi.emir.db.ServiceDatabase;
import eu.emi.emir.db.mongodb.ServiceObject;
import eu.emi.emir.event.Event;
import eu.emi.emir.event.EventDispatcher;
import eu.emi.emir.validator.InvalidServiceDescriptionException;
import eu.emi.emir.validator.RegistrationValidator;
import eu.unicore.util.configuration.ConfigurationException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class MongoDBServiceDatabase
implements ServiceDatabase {
    private static Logger logger = Log.getLogger((String)"emir.db", MongoDBServiceDatabase.class);
    private static Mongo connection;
    private DB database;
    private DBCollection serviceCollection;

    public MongoDBServiceDatabase() {
        if (EMIRServer.getServerProperties() == null) {
            new EMIRServer();
        }
        String hostname = EMIRServer.getServerProperties().getValue("mongodb.hostName");
        Integer port = EMIRServer.getServerProperties().getIntValue("mongodb.port");
        String dbName = EMIRServer.getServerProperties().getValue("mongodb.dbName");
        String colName = EMIRServer.getServerProperties().getValue("mongodb.collectionName");
        String dbUserName = EMIRServer.getServerProperties().getValue("mongodb.userName");
        String dbPassword = EMIRServer.getServerProperties().getValue("mongodb.password");
        try {
            if (connection == null) {
                MongoOptions mo = new MongoOptions();
                mo.autoConnectRetry = true;
                mo.connectTimeout = 100;
                mo.maxWaitTime = 100;
                mo.socketKeepAlive = true;
                mo.connectionsPerHost = 255;
                ServerAddress sa = new ServerAddress(hostname, Integer.valueOf(port).intValue());
                connection = new Mongo(sa, mo);
            }
            this.database = connection.getDB(dbName);
            if (!(dbUserName == null || dbUserName.equalsIgnoreCase("") || dbPassword.equalsIgnoreCase("") || this.database.authenticate(dbUserName, dbPassword.toCharArray()))) {
                Log.logException((String)("Cannot authenticate the user: " + dbUserName + "\nProvide the correct MongoDB database username and password in configuration file and restart the EMIR server again"), (Throwable)new RuntimeException("MongoDB Authentication Failed"));
                System.out.printf("%s:%s.%s.%s", "Error occurred while starting the EMIR server", "Cannot authenticate the database User: " + dbUserName, " Provide the correct MongoDB database username and password in configuration file and restart the EMIR server again", " Stoppoing the EMIR server.");
                System.exit(1);
            }
            this.serviceCollection = this.database.getCollection(colName);
            BasicDBObject obj = new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)"1");
            this.serviceCollection.ensureIndex((DBObject)obj, ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), true);
        }
        catch (MongoException e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
            logger.warn((Object)e.getCause());
        }
        catch (Exception e) {
            logger.error((Object)"Error in connecting the MongoDB database", (Throwable)e);
        }
    }

    public MongoDBServiceDatabase(String hostname, Integer port, String dbName, String colName) {
        try {
            if (connection == null) {
                connection = new Mongo(hostname, port.intValue());
            }
            this.database = connection.getDB(dbName);
            this.serviceCollection = this.database.getCollection(colName);
            BasicDBObject obj = new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)"1");
            this.serviceCollection.ensureIndex((DBObject)obj, ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unique index created: " + obj));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in connecting the MongoDB database", (Throwable)e);
        }
    }

    @Override
    public void insert(ServiceObject item) throws ExistingResourceException, PersistentStoreFailureException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("inserting: " + item.toDBObject()));
            }
            this.database.requestStart();
            this.database.requestEnsureConnection();
            DBObject db = item.toDBObject();
            this.serviceCollection.insert(db, WriteConcern.SAFE);
            this.database.requestDone();
            logger.info((Object)("inserted Service Endpoint record with ID: " + item.getEndpointID()));
        }
        catch (MongoException e) {
            if (e instanceof MongoException.DuplicateKey) {
                throw new ExistingResourceException("Endpoint record with ID: " + item.getEndpointID() + " - already exists", e);
            }
            throw new PersistentStoreFailureException(e);
        }
    }

    @Override
    public ServiceObject getServiceByUrl(String identifier) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        ServiceObject so = null;
        try {
            DBObject db = this.serviceCollection.findOne((DBObject)new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_URL.getAttributeName(), (Object)identifier));
            if (db == null) {
                return null;
            }
            so = new ServiceObject(db);
        }
        catch (MongoException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (JSONException e) {
            throw new NonExistingResourceException(e);
        }
        return so;
    }

    @Override
    public ServiceObject getServiceByEndpointID(String identifier) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        ServiceObject so = null;
        try {
            System.out.println(this.findAll());
            DBObject db = this.serviceCollection.findOne((DBObject)new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)identifier));
            if (db == null) {
                return null;
            }
            so = new ServiceObject(db);
        }
        catch (MongoException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (JSONException e) {
            throw new NonExistingResourceException(e);
        }
        return so;
    }

    @Override
    public void deleteByEndpointID(String endpointID) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        this.database.requestStart();
        this.database.requestEnsureConnection();
        BasicDBObject query = new BasicDBObject();
        query.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)endpointID);
        DBObject d = this.serviceCollection.findAndRemove((DBObject)query);
        this.database.requestDone();
        if (d == null) {
            if (logger.isDebugEnabled()) {
                String msg = "No service description with the Endpoint ID:" + endpointID + " exists";
                logger.debug((Object)msg);
            }
            throw new NonExistingResourceException("No service description with the Endpoint ID:" + endpointID + " exists");
        }
        logger.info((Object)("deleted: " + endpointID));
        try {
            JSONObject deletedEntry = new JSONObject(d.toString());
            EventDispatcher.notifyRecievers(new Event("service_delete", deletedEntry));
        }
        catch (JSONException e) {
            logger.warn((Object)e.getCause());
        }
    }

    @Override
    public void update(ServiceObject sObj) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException {
        try {
            String id = sObj.getServiceID();
            logger.debug((Object)("updating service description: " + sObj));
            this.database.requestStart();
            this.database.requestEnsureConnection();
            DBObject dbObj = sObj.toDBObject();
            BasicDBObject query = new BasicDBObject();
            query.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)sObj.getEndpointID());
            DBObject db = this.serviceCollection.findOne((DBObject)new BasicDBObject(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)sObj.getEndpointID()));
            if (db == null) {
                try {
                    new RegistrationValidator().validateInfo(sObj.toJSON());
                }
                catch (ConfigurationException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
                catch (InvalidServiceDescriptionException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
                catch (JSONException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
                catch (ParseException e) {
                    Log.logException((String)("Error during the update message validation. (ID:" + id + ")"), (Throwable)e, (Logger)logger);
                    return;
                }
            }
            this.serviceCollection.update((DBObject)query, dbObj, true, false);
            this.database.requestDone();
            logger.info((Object)("updated Service Endpoint Record with ID: " + id));
        }
        catch (MongoException e) {
            Log.logException((String)("Error updating the Service Record in MongoDB: " + sObj), (Throwable)e, (Logger)logger);
        }
    }

    @Override
    public List<ServiceObject> query(String query) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o);
        CopyOnWriteArrayList<ServiceObject> resultCollection = new CopyOnWriteArrayList<ServiceObject>();
        try {
            while (cur.hasNext()) {
                ServiceObject s = new ServiceObject(cur.next().toString());
                resultCollection.add(s);
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return Collections.unmodifiableList(resultCollection);
    }

    @Override
    public List<ServiceObject> query(String query, Integer limit, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue()).limit(limit.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        ArrayList<ServiceObject> resultCollection = new ArrayList<ServiceObject>();
        try {
            while (cur.hasNext()) {
                ServiceObject s = new ServiceObject(cur.next());
                resultCollection.add(s);
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return Collections.unmodifiableList(resultCollection);
    }

    @Override
    public List<ServiceObject> query(String query, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue());
        logger.debug((Object)cur.getCursorId());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        ArrayList<ServiceObject> resultCollection = new ArrayList<ServiceObject>();
        try {
            while (cur.hasNext()) {
                ServiceObject s = new ServiceObject(cur.next().toString());
                resultCollection.add(s);
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return Collections.unmodifiableList(resultCollection);
    }

    @Override
    public JSONArray queryJSON(String query) throws QueryException, PersistentStoreFailureException, MongoException, JSONException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o);
        JSONArray arr = new JSONArray();
        while (cur.hasNext()) {
            arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
        }
        cur.close();
        return arr;
    }

    @Override
    public JSONArray queryJSON(String query, Integer limit, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue()).limit(limit.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public JSONArray queryJSON(String query, Integer skip) throws QueryException, PersistentStoreFailureException {
        DBObject o = (DBObject)JSON.parse((String)query);
        DBCursor cur = this.serviceCollection.find(o).skip(skip.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public JSONArray queryJSONWithLimit(String s, Integer limit) {
        DBObject o = (DBObject)JSON.parse((String)s);
        DBCursor cur = this.serviceCollection.find(o).limit(limit.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("result size: " + cur.size()));
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public JSONArray queryDistinctJSON(String attributeName) {
        String s = "{ " + ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName() + " : { $exists : true } }";
        DBObject query = (DBObject)JSON.parse((String)s);
        List lst = this.serviceCollection.distinct(attributeName, query);
        JSONArray arr = new JSONArray((Collection)lst);
        return arr;
    }

    @Override
    public JSONArray paginatedQuery(String query, Integer pageSize, String id) {
        return this.paginatedQuery(query, pageSize, id, "_id");
    }

    @Override
    public JSONArray paginatedQuery(String query, Integer pageSize, String id, String orderBy) {
        DBObject queryObj = (DBObject)JSON.parse((String)query);
        DBCursor cur = null;
        if (orderBy == null || orderBy.isEmpty()) {
            orderBy = "_id";
        }
        BasicDBObject OrderBy = new BasicDBObject(orderBy, (Object)1);
        if (id == null) {
            cur = this.serviceCollection.find(queryObj).sort((DBObject)OrderBy).limit(pageSize.intValue());
        } else {
            StringBuffer b = new StringBuffer();
            b.append("{").append("\"_id\"").append(":").append("{").append("\"$gt\":").append("{").append("\"$oid\"").append(":\"").append(id).append("\"}").append("}}");
            DBObject db = (DBObject)JSON.parse((String)b.toString());
            if (queryObj.keySet().size() > 0) {
                db.putAll((BSONObject)queryObj);
            }
            cur = this.serviceCollection.find(db).sort((DBObject)OrderBy).limit(pageSize.intValue());
        }
        JSONArray arr = new JSONArray();
        try {
            while (cur.hasNext()) {
                arr.put((Object)new JSONObject(JSON.serialize((Object)cur.next())));
            }
            cur.close();
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e);
        }
        return arr;
    }

    @Override
    public void deleteAll() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"deleting all the contents from the db collection");
        }
        BasicDBObject o = new BasicDBObject(0);
        this.database.requestStart();
        this.serviceCollection.remove((DBObject)o);
        this.database.requestDone();
        logger.info((Object)"deleted all the contents from the db collection");
    }

    @Override
    public List<ServiceObject> findAll() throws JSONException {
        CopyOnWriteArrayList<ServiceObject> lst = new CopyOnWriteArrayList<ServiceObject>();
        DBCursor c = this.serviceCollection.find();
        while (c.hasNext()) {
            DBObject type = c.next();
            ServiceObject s = new ServiceObject(type.toString());
            lst.add(s);
        }
        c.close();
        return Collections.unmodifiableList(lst);
    }

    @Override
    public void findAndDelete(String query) {
        DBObject db = (DBObject)JSON.parse((String)query);
        if (logger.isTraceEnabled()) {
            logger.debug((Object)("delete by query: " + db.toString()));
        }
        this.database.requestStart();
        this.database.requestEnsureConnection();
        this.serviceCollection.remove(db);
        this.database.requestDone();
    }

    public void dropCollection() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dropping collection: " + this.serviceCollection.getName()));
        }
        this.serviceCollection.drop();
    }

    public void dropDB() {
        this.database.dropDatabase();
    }

    @Override
    public String getDBVersion() {
        CommandResult result = this.database.command("serverStatus");
        return result.getString("version");
    }
}

