/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.core;

import eu.emi.emir.EMIRServer;
import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.db.ExistingResourceException;
import eu.emi.emir.db.MultipleResourceException;
import eu.emi.emir.db.NonExistingResourceException;
import eu.emi.emir.db.PersistentStoreFailureException;
import eu.emi.emir.db.QueryException;
import eu.emi.emir.db.ServiceDatabase;
import eu.emi.emir.db.mongodb.MongoDBServiceDatabase;
import eu.emi.emir.db.mongodb.ServiceObject;
import eu.emi.emir.event.Event;
import eu.emi.emir.event.EventDispatcher;
import eu.emi.emir.exception.UnknownServiceException;
import eu.emi.emir.validator.InvalidServiceDescriptionException;
import eu.emi.emir.validator.RegistrationValidator;
import eu.unicore.util.configuration.ConfigurationException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ServiceAdminManager {
    private static Logger log = Log.getLogger((String)"emir.core", ServiceAdminManager.class);
    private ServiceDatabase serviceDB = null;

    public ServiceAdminManager() {
        this.serviceDB = new MongoDBServiceDatabase();
    }

    public ServiceAdminManager(MongoDBServiceDatabase mongoDB) {
        this.serviceDB = mongoDB;
    }

    public JSONObject addService(JSONObject jo) throws InvalidServiceDescriptionException, JSONException, ExistingResourceException, ConfigurationException, ParseException {
        block12: {
            new RegistrationValidator().validateInfo(jo);
            try {
                JSONObject date = new JSONObject();
                date.put("$date", (Object)DateUtil.toUTCFormat((Date)new Date()));
                jo.put(ServiceBasicAttributeNames.SERVICE_CREATED_ON.getAttributeName(), (Object)date);
                if (!jo.has(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())) {
                    jo.put(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName(), (Object)date);
                }
                if (!jo.has(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName())) {
                    Integer expTime = EMIRServer.getServerProperties().getIntValue("record.expiryDefault");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The expiry attribute is missing from the registered service information. The information will be expired in " + expTime + "day from now"));
                    }
                    DateUtil.setExpiryTime((JSONObject)jo, (Integer)expTime);
                }
                this.serviceDB.insert(new ServiceObject(jo));
                return jo;
            }
            catch (PersistentStoreFailureException e) {
                Log.logException((String)"", (Throwable)e, (Logger)log);
            }
            catch (ExistingResourceException e) {
                if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue()) {
                    try {
                        if (this.serviceDB.getServiceByEndpointID(jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName())).getServiceOwner() == null || jo.getString(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName()).equals(EMIRServer.getServerProperties().getValue("address"))) {
                            this.serviceDB.update(new ServiceObject(jo));
                            return jo;
                        }
                        throw new ExistingResourceException(e);
                    }
                    catch (MultipleResourceException e1) {
                        Log.logException((String)"", (Throwable)e, (Logger)log);
                        break block12;
                    }
                    catch (NonExistingResourceException e1) {
                        Log.logException((String)"", (Throwable)e, (Logger)log);
                        break block12;
                    }
                    catch (PersistentStoreFailureException e1) {
                        Log.logException((String)"", (Throwable)e, (Logger)log);
                        break block12;
                    }
                }
                throw new ExistingResourceException(e);
            }
        }
        return null;
    }

    public void removeService(String endpointID, String messageTime) throws MultipleResourceException, NonExistingResourceException, PersistentStoreFailureException, JSONException {
        if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue()) {
            JSONObject newEntry = new JSONObject();
            newEntry.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)endpointID);
            JSONObject date = new JSONObject();
            date.put("$date", (Object)messageTime);
            newEntry.put(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName(), (Object)date);
            ServiceObject sObj = new ServiceObject(newEntry);
            try {
                this.serviceDB.update(sObj);
                JSONArray arr = new JSONArray();
                arr.put((Object)newEntry);
                EventDispatcher.notifyRecievers(new Event("service_update", arr));
            }
            catch (MultipleResourceException e) {
                Log.logException((String)"", (Throwable)e, (Logger)log);
            }
            catch (NonExistingResourceException e) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            catch (PersistentStoreFailureException e) {
                Log.logException((String)"", (Throwable)e, (Logger)log);
            }
        } else {
            this.serviceDB.deleteByEndpointID(endpointID);
        }
    }

    public JSONObject updateService(JSONObject jo) throws UnknownServiceException, InvalidServiceDescriptionException, JSONException, WebApplicationException, ConfigurationException, ParseException {
        new RegistrationValidator().validateInfo(jo);
        if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue()) {
            new RegistrationValidator().validateEndpointIDInfo(jo);
        }
        Integer expTime = EMIRServer.getServerProperties().getIntValue("record.expiryDefault");
        if (log.isDebugEnabled()) {
            log.debug((Object)("The expiry attribute is missing from the updated service information. The information will be expired in " + expTime + "day from now"));
        }
        DateUtil.setExpiryTime((JSONObject)jo, (Integer)expTime);
        if (!jo.has(ServiceBasicAttributeNames.SERVICE_CREATED_ON.getAttributeName())) {
            JSONObject date = new JSONObject();
            date.put("$date", (Object)DateUtil.toUTCFormat((Date)new Date()));
            jo.put(ServiceBasicAttributeNames.SERVICE_CREATED_ON.getAttributeName(), (Object)date);
        }
        if (!jo.has(ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName())) {
            jo = DateUtil.addDate((JSONObject)jo, (String)ServiceBasicAttributeNames.SERVICE_UPDATE_SINCE.getAttributeName(), (Date)new Date());
        }
        ServiceObject sObj = new ServiceObject(jo);
        try {
            this.serviceDB.update(sObj);
            return jo;
        }
        catch (MultipleResourceException e) {
            Log.logException((String)"", (Throwable)e, (Logger)log);
        }
        catch (NonExistingResourceException e) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        catch (PersistentStoreFailureException e) {
            Log.logException((String)"", (Throwable)e, (Logger)log);
        }
        return null;
    }

    public JSONObject findServiceByUrl(String url) throws NonExistingResourceException, PersistentStoreFailureException {
        ServiceObject so = null;
        try {
            so = this.serviceDB.getServiceByUrl(url);
        }
        catch (MultipleResourceException e) {
            Log.logException((String)"", (Throwable)e, (Logger)log);
        }
        if (so == null) {
            return null;
        }
        return so.toJSON();
    }

    public JSONObject findServiceByEndpointID(String endpointID) throws NonExistingResourceException, PersistentStoreFailureException {
        ServiceObject so = null;
        try {
            so = this.serviceDB.getServiceByEndpointID(endpointID);
        }
        catch (MultipleResourceException e) {
            Log.logException((String)"", (Throwable)e);
        }
        if (so == null) {
            return null;
        }
        return so.toJSON();
    }

    public void removeExpiredEntries() throws JSONException, QueryException, PersistentStoreFailureException {
        JSONObject date = new JSONObject();
        JSONObject predicate = new JSONObject();
        JSONObject query = new JSONObject();
        date.put("$date", (Object)DateUtil.toUTCFormat((Date)new Date()));
        predicate.put("$lte", (Object)date);
        query.put(ServiceBasicAttributeNames.SERVICE_EXPIRE_ON.getAttributeName(), (Object)predicate);
        this.serviceDB.findAndDelete(query.toString());
    }

    public void removeAll() {
        this.serviceDB.deleteAll();
    }

    public List<ServiceObject> findAll() throws JSONException {
        return this.serviceDB.findAll();
    }

    public boolean checkOwner(String owner, String sendpointID) throws QueryException, PersistentStoreFailureException, JSONException {
        List<Object> query = new ArrayList();
        JSONArray and1 = new JSONArray();
        JSONObject andParam1 = new JSONObject();
        andParam1.put(ServiceBasicAttributeNames.SERVICE_OWNER_DN.getAttributeName(), (Object)owner);
        and1.put((Object)andParam1);
        JSONObject andParam2 = new JSONObject();
        andParam2.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)sendpointID);
        and1.put((Object)andParam2);
        JSONObject orParam1 = new JSONObject();
        orParam1.put("$and", (Object)and1);
        JSONArray and2 = new JSONArray();
        JSONObject andParam21 = new JSONObject();
        andParam21.put(ServiceBasicAttributeNames.SERVICE_DN.getAttributeName(), (Object)owner);
        and2.put((Object)andParam21);
        JSONObject andParam22 = new JSONObject();
        andParam22.put(ServiceBasicAttributeNames.SERVICE_TYPE.getAttributeName(), (Object)"GSR");
        and2.put((Object)andParam22);
        JSONObject orParam2 = new JSONObject();
        orParam2.put("$and", (Object)and2);
        JSONArray or = new JSONArray();
        or.put((Object)orParam1);
        or.put((Object)orParam2);
        JSONObject OR = new JSONObject();
        OR.put("$or", (Object)or);
        query = this.serviceDB.query(OR.toString());
        if (!query.isEmpty()) {
            return true;
        }
        JSONObject entryExist = new JSONObject();
        entryExist.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), (Object)sendpointID);
        if (this.serviceDB.query(entryExist.toString()).isEmpty()) {
            return true;
        }
        log.debug((Object)("Wrong owner (" + owner + ") try to modify this Service Endpoint ID: " + sendpointID));
        return false;
    }

    public boolean checkMessageGenerationTime(String messageTime, String sendpointID) throws QueryException, PersistentStoreFailureException {
        if (!EMIRServer.getServerProperties().isGlobalEnabled().booleanValue()) {
            return true;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ServiceBasicAttributeNames.SERVICE_ENDPOINT_ID.getAttributeName(), sendpointID);
        JSONObject jo = new JSONObject(map);
        List<ServiceObject> storedEntries = this.serviceDB.query(jo.toString());
        if (storedEntries.size() > 0) {
            Date messageDate = new Date();
            try {
                messageDate = DateUtil.UTCISODateFormat.parse(DateUtil.toUTCFormat((Date)messageDate));
                messageDate = DateUtil.UTCISODateFormat.parse(messageTime);
            }
            catch (ParseException e) {
                // empty catch block
            }
            Date entryDate = storedEntries.get(0).getUpdateSince();
            if (messageDate.compareTo(entryDate) > 0) {
                return true;
            }
            log.debug((Object)"The incoming entry was too old and don't accept it.");
            return false;
        }
        return true;
    }
}

