/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.aip;

import eu.emi.emir.aip.Attribute;
import eu.emi.emir.aip.AttributesFileParser;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.security.IAttributeSource;
import eu.emi.emir.security.SecurityTokens;
import eu.emi.emir.security.SubjectAttributesHolder;
import eu.emi.emir.security.XACMLAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class FileAttributeSource
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"emir.security", FileAttributeSource.class);
    private File uudbFile = new File("conf", "simpleuudb");
    private boolean strictMatching = true;
    private long lastChanged;
    private String name;
    private String status = "OK";
    private Map<String, List<Attribute>> map;
    public static final String SPECIAL_XLOGIN = "xlogin";
    public static final String SPECIAL_ROLE = "role";
    public static final String SPECIAL_GROUP = "group";
    public static final String SPECIAL_SUP_GROUPS = "supplementaryGroups";
    public static final String SPECIAL_ADD_OS_GIDS = "addOsGroups";
    public static final String SPECIAL_QUEUE = "queue";

    @Override
    public void init(String name) throws Exception {
        this.name = name;
        AttributesFileParser parser = new AttributesFileParser(new FileInputStream(this.uudbFile));
        this.lastChanged = this.uudbFile.lastModified();
        try {
            this.map = parser.parse();
            if (this.strictMatching) {
                this.canonMap();
            }
        }
        catch (IOException e) {
            this.status = e.getMessage();
            throw e;
        }
    }

    @Override
    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        this.parseIfNeeded();
        String subject = tokens.getUserName().getName("CANONICAL");
        List<Attribute> attrs = this.searchFor(subject);
        HashMap<String, String[]> retAll = new HashMap<String, String[]>();
        HashMap<String, String[]> retFirst = new HashMap<String, String[]>();
        ArrayList<XACMLAttribute> retXACML = new ArrayList<XACMLAttribute>();
        if (attrs != null) {
            this.putAttributes(attrs, retAll, retFirst, retXACML);
        }
        return new SubjectAttributesHolder(retXACML, retFirst, retAll);
    }

    private void putAttributes(List<Attribute> attrs, Map<String, String[]> allIncRet, Map<String, String[]> firstIncRet, List<XACMLAttribute> authzRet) {
        for (Attribute a : attrs) {
            String name = a.getName();
            boolean isIncarnation = true;
            if (name.equalsIgnoreCase(SPECIAL_ROLE)) {
                name = SPECIAL_ROLE;
            } else if (name.equalsIgnoreCase(SPECIAL_GROUP)) {
                name = SPECIAL_GROUP;
            } else if (name.equalsIgnoreCase(SPECIAL_SUP_GROUPS)) {
                name = SPECIAL_SUP_GROUPS;
            } else if (name.equalsIgnoreCase(SPECIAL_ADD_OS_GIDS)) {
                name = "addDefaultGroups";
            } else {
                isIncarnation = false;
            }
            if (isIncarnation) {
                if (!name.equals(SPECIAL_SUP_GROUPS)) {
                    if (a.getValues().size() > 0) {
                        firstIncRet.put(name, new String[]{a.getValues().get(0)});
                    } else {
                        firstIncRet.put(name, new String[0]);
                    }
                } else {
                    firstIncRet.put(name, a.getValues().toArray(new String[a.getValues().size()]));
                }
                allIncRet.put(name, a.getValues().toArray(new String[a.getValues().size()]));
                continue;
            }
            List<String> values = a.getValues();
            for (String value : values) {
                authzRet.add(new XACMLAttribute(name, value, XACMLAttribute.Type.STRING));
            }
            if (values.size() != 0) continue;
            logger.info((Object)("XACML Authorization attribute '" + name + "' defined without a value, ignoring"));
        }
    }

    private List<Attribute> searchFor(String name) {
        if (this.strictMatching) {
            return this.map.get(name);
        }
        for (String pattern : this.map.keySet()) {
            Pattern p = Pattern.compile(pattern, 2);
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            return this.map.get(pattern);
        }
        return null;
    }

    private void parseIfNeeded() {
        long lastMod = this.uudbFile.lastModified();
        if (lastMod <= this.lastChanged) {
            return;
        }
        this.lastChanged = lastMod;
        try {
            AttributesFileParser parser = new AttributesFileParser(new FileInputStream(this.uudbFile));
            this.map = parser.parse();
            if (this.strictMatching) {
                this.canonMap();
            }
            logger.info((Object)("Updated user attributes were loaded from the file " + this.uudbFile));
        }
        catch (IOException e) {
            logger.error((Object)("The updated attributes list is INVALID: " + e.getMessage()));
        }
    }

    private void canonMap() {
        HashMap<String, List<Attribute>> map2 = new HashMap<String, List<Attribute>>();
        for (Map.Entry<String, List<Attribute>> e : this.map.entrySet()) {
            String key = e.getKey();
            X500Principal x500 = new X500Principal(key);
            map2.put(x500.getName("CANONICAL"), e.getValue());
        }
        this.map = map2;
    }

    @Override
    public String getStatusDescription() {
        return "File Attribute Source [" + this.name + "]: " + this.status + ", using map file " + this.uudbFile.getAbsolutePath();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setFile(String uudbFile) {
        this.uudbFile = new File(uudbFile);
    }

    public void setMatching(String val) {
        if (val.equalsIgnoreCase(MatchingTypes.STRICT.name())) {
            this.strictMatching = true;
        } else if (val.equalsIgnoreCase(MatchingTypes.REGEXP.name())) {
            this.strictMatching = false;
        } else {
            logger.error((Object)("Invalid value of the 'matching' configuration option: " + val + ", using default: " + (Object)((Object)MatchingTypes.STRICT)));
        }
    }

    @Override
    public String[] getAcceptedVOs() {
        return null;
    }

    private static enum MatchingTypes {
        STRICT,
        REGEXP;

    }
}

