/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.aip;

import eu.emi.emir.aip.Attribute;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class AttributesFileParser {
    private InputStream is;
    private static final String MAIN_EL = "fileAttributeSource";
    private static final String ENTRY_EL = "entry";
    private static final String ATTR_EL = "attribute";
    private static final String VALUE_EL = "value";
    private static final String KEY_EL = "key";
    private static final QName KEY_AT = new QName("key");
    private static final QName NAME_AT = new QName("name");

    public AttributesFileParser(InputStream is) {
        this.is = is;
    }

    public Map<String, List<Attribute>> parse() throws IOException {
        StartElement entry;
        LinkedHashMap<String, List<Attribute>> ret = new LinkedHashMap<String, List<Attribute>>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        try {
            reader = factory.createXMLEventReader(new BufferedInputStream(this.is));
        }
        catch (XMLStreamException e) {
            throw new IOException("Can't initialize XML parser: " + e.toString());
        }
        StartElement start = this.getNextElement(reader, MAIN_EL, null);
        if (start == null) {
            throw new IOException("File must start with fileAttributeSource element.");
        }
        while (reader.hasNext() && (entry = this.getNextElement(reader, ENTRY_EL, MAIN_EL)) != null) {
            StartElement attribute;
            String key = null;
            javax.xml.stream.events.Attribute a = entry.getAttributeByName(KEY_AT);
            if (a != null) {
                key = a.getValue();
            } else {
                StartElement keyElement = this.getNextElement(reader, KEY_EL, ATTR_EL);
                if (keyElement != null) {
                    key = this.readTextContent(reader).trim();
                }
            }
            if (key == null) {
                throw new IOException("Got entry without key!");
            }
            if (ret.containsKey(key)) {
                throw new IOException("The same entry key used twice: " + key);
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            while (reader.hasNext() && (attribute = this.getNextElement(reader, ATTR_EL, ENTRY_EL)) != null) {
                StartElement value;
                javax.xml.stream.events.Attribute a2 = attribute.getAttributeByName(NAME_AT);
                if (a2 == null) {
                    throw new IOException("Got attribute without name attribute");
                }
                String attributeName = a2.getValue();
                ArrayList<String> values = new ArrayList<String>();
                Attribute toAdd = new Attribute(attributeName, values);
                while (reader.hasNext() && (value = this.getNextElement(reader, VALUE_EL, ATTR_EL)) != null) {
                    String valueStr = this.readTextContent(reader);
                    values.add(valueStr);
                }
                attributes.add(toAdd);
            }
            ret.put(key, attributes);
        }
        this.is.close();
        return ret;
    }

    private XMLEvent readNext(XMLEventReader reader) throws IOException {
        try {
            return reader.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error in XML syntax at " + e.getLocation() + ": " + e.getMessage());
        }
    }

    private StartElement getNextElement(XMLEventReader reader, String searchedElement, String limitElement) throws IOException {
        while (reader.hasNext()) {
            XMLEvent event = this.readNext(reader);
            if (event instanceof StartElement) {
                StartElement el = (StartElement)event;
                if (!el.getName().getLocalPart().equals(searchedElement)) {
                    throw new IOException("Expected " + searchedElement + " but found " + el.getName());
                }
                return el;
            }
            if (!(event instanceof EndElement)) continue;
            EndElement end = (EndElement)event;
            if (limitElement == null || !end.getName().getLocalPart().equals(limitElement)) continue;
            return null;
        }
        return null;
    }

    private String readTextContent(XMLEventReader reader) throws IOException {
        try {
            return reader.getElementText();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error in XML syntax at " + e.getLocation() + ": " + e.getMessage());
        }
    }
}

