/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.Mongo;
import eu.emi.emir.ServerProperties;
import eu.emi.emir.client.util.Log;
import eu.emi.emir.core.RegistryThreadPool;
import eu.emi.emir.infrastructure.ServiceCheckin;
import eu.emi.emir.infrastructure.ServiceEventReceiver;
import eu.emi.emir.jetty.HttpServer;
import eu.emi.emir.jetty.HttpsServer;
import eu.emi.emir.lease.ServiceReaper;
import eu.emi.emir.p2p.GSRHelper;
import eu.emi.emir.security.ClientSecurityProperties;
import eu.emi.emir.security.ServerSecurityProperties;
import eu.unicore.util.configuration.FilePropertiesHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.server.Server;

public class EMIRServer {
    private static final Logger logger = Log.getLogger((String)"emir.httpserver", EMIRServer.class);
    private static ServerSecurityProperties secProps;
    private static ServerProperties serverProps;
    private static ClientSecurityProperties clientSecProps;
    private static Date runningSince;
    private Server server;
    private static Properties rawProps;

    public EMIRServer() {
        EMIRServer.initLogging();
    }

    public EMIRServer(Properties p) {
        EMIRServer.initLogging();
        serverProps = new ServerProperties(p, false);
    }

    public static void main(String[] args) {
        EMIRServer.initLogging();
        if (args.length == 0) {
            EMIRServer.printUsage();
        } else {
            EMIRServer s = new EMIRServer();
            s.run(args[0]);
            final EMIRServer serverPointer = s;
            Runtime.getRuntime().addShutdownHook(new Thread(){
                private Logger threadLogger = Log.getLogger((String)"emir.core", EMIRServer.class);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.threadLogger.debug((Object)"EMIR server is stopping now (shutdown hook)");
                    if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue()) {
                        try {
                            serverPointer.stop();
                        }
                        catch (NullPointerException e) {
                            System.err.println("Unknown (NULL) failure");
                        }
                        catch (Throwable e) {
                            Log.logException((String)"shutdown hook", (Throwable)e);
                        }
                        finally {
                            GSRHelper.stopGSRFunctions();
                        }
                    }
                    this.threadLogger.debug((Object)"EMIR server stopped (shutdown hook)");
                }
            });
        }
    }

    public void run(String propsFilePath) {
        try {
            rawProps = FilePropertiesHelper.load((String)propsFilePath);
            this.run(rawProps);
        }
        catch (IOException e) {
            logger.error((Object)"Problem starting the server", (Throwable)e);
            e.printStackTrace();
            System.out.println("Cannot start EMIR.");
            System.exit(1);
        }
    }

    public void run(Properties props) {
        HttpsServer server = null;
        HttpServer anonymousServer = null;
        try {
            server = new HttpsServer(props);
            secProps = server.getServerSecProps();
            serverProps = server.getServerProps();
            clientSecProps = server.getClientSecProps();
            rawProps = props;
            server.start();
            if (serverProps.isAnonymousAccessEnabled().booleanValue() && secProps.isSslEnabled()) {
                anonymousServer = new HttpServer(props);
                anonymousServer.start();
            }
            this.server = server.getJettyServer().getServer();
        }
        catch (Exception e) {
            logger.error((Object)"Problem starting the server", (Throwable)e);
            e.printStackTrace();
            System.out.println("Cannot start EMIR.");
            System.exit(1);
        }
        this.handleGSR();
        this.startServiceReaper();
    }

    private static void initLogging() {
        runningSince = new Date();
        String logConfig = System.getProperty("log4j.configuration");
        if (logConfig == null) {
            logger.debug((Object)"No log4j config defined.");
            return;
        }
        PropertyConfigurator.configure((String)logConfig);
        LogManager l = LogManager.getLogManager();
        try {
            l.readConfiguration(new FileInputStream(new File(logConfig)));
        }
        catch (SecurityException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (IOException e) {
            Log.logException((String)"", (Throwable)e);
        }
    }

    private void handleGSR() {
        String type = "DSR";
        ServerProperties sp = EMIRServer.getServerProperties();
        if (sp.isGlobalEnabled().booleanValue()) {
            type = "GSR";
            GSRHelper.startGSRFunctions();
        } else {
            this.addParentDSR();
        }
        String v = ServerProperties.class.getPackage().getImplementationVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("EMIR Server ");
        if (v != null) {
            sb.append("v" + v);
        }
        sb.append(" [TYPE: " + type + "] [URL:" + sp.getValue("address") + "] STARTED");
        String startMessage = sb.toString();
        System.out.println(startMessage);
        logger.info((Object)startMessage);
        this.printMongoConnectionStatus();
    }

    private void printMongoConnectionStatus() {
        DB db = null;
        String version = null;
        String hostName = EMIRServer.getServerProperties().getValue("mongodb.hostName");
        Integer portNumber = EMIRServer.getServerProperties().getIntValue("mongodb.port");
        try {
            db = Mongo.connect((DBAddress)new DBAddress(EMIRServer.getServerProperties().getValue("mongodb.hostName"), EMIRServer.getServerProperties().getIntValue("mongodb.port").intValue(), EMIRServer.getServerProperties().getValue("mongodb.dbName")));
            CommandResult result = db.command("serverStatus");
            version = result.getString("version");
            StringBuilder sb = new StringBuilder();
            sb.append("Connection to MongoDB v");
            sb.append(version);
            sb.append(" [").append(hostName).append(":").append(portNumber).append("]");
            sb.append("OK / AVAILABLE");
            System.out.println(sb.toString());
            logger.info((Object)sb.toString());
        }
        catch (Exception e) {
            logger.warn((Object)("Connection to MongoDB [" + hostName + ":" + portNumber + "] failed"));
        }
    }

    private void startServiceReaper() {
        try {
            RegistryThreadPool.getScheduledExecutorService().scheduleWithFixedDelay(new ServiceReaper(), 10L, 300L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot start service record reaper", (Throwable)e);
        }
    }

    public void addParentDSR() {
        String parentUrl = EMIRServer.getServerProperties().getValue("parentAddress");
        String serverUrl = EMIRServer.getServerProperties().getValue("address");
        if (parentUrl != null) {
            logger.debug((Object)("Configured server's URL: " + serverUrl));
            try {
                URL server = new URL(serverUrl);
                URL parent = new URL(parentUrl);
                if (server.equals(parent)) {
                    logger.warn((Object)("Configured same URL (" + serverUrl + ") to the own address and to the parent!"));
                    logger.info((Object)"Wrong Parent URL! Entry forwarding function turned OFF!");
                    return;
                }
            }
            catch (MalformedURLException e1) {
                Log.logException((String)"Wrong address or parent URL setted by EMIR Server configuration", (Throwable)e1, (Logger)logger);
            }
            logger.info((Object)("The parent EMIR URL is set to: " + parentUrl));
            RegistryThreadPool.getExecutorService().execute(new ServiceEventReceiver(parentUrl));
            Long max = EMIRServer.getServerProperties().getLongValue("record.maximum");
            try {
                RegistryThreadPool.getExecutorService().execute(new ServiceCheckin(parentUrl, serverUrl, max));
            }
            catch (Throwable e) {
                logger.warn((Object)"The parent EMIR is not available.");
            }
        }
    }

    public void stop() {
        try {
            this.server.stop();
            this.finalize();
            System.out.println("EMIR server stopped");
            logger.info((Object)"EMIR server stopped");
        }
        catch (Exception e) {
            System.err.println("Error shutting down the EMIR Server");
            Log.logException((String)"Error shutting down the EMIR Server", (Throwable)e, (Logger)logger);
        }
    }

    protected void finalize() {
        if (EMIRServer.getServerProperties().isGlobalEnabled().booleanValue() && this.server.isRunning()) {
            GSRHelper.stopGSRFunctions();
        }
    }

    public static Date getRunningSince() {
        return runningSince;
    }

    public static ServerSecurityProperties getServerSecurityProperties() {
        return secProps;
    }

    public static ClientSecurityProperties getClientSecurityProperties() {
        return clientSecProps;
    }

    public static void printUsage() {
        System.out.println("\nUsage: start_cmd  <command>  [parameters]\n\t<configfile>  starts EMIR server");
    }

    public Server getJettyServer() {
        return this.server;
    }

    public static ServerProperties getServerProperties() {
        return serverProps;
    }

    public static Properties getRawProperties() {
        return rawProps;
    }

    static {
        runningSince = null;
    }
}

