/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.client.util;

import eu.emi.emir.client.ServiceBasicAttributeNames;
import eu.emi.emir.client.util.DateUtil;
import eu.emi.emir.client.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class ServiceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    private static void initList() {
        if (DateUtil.lstNames == null) {
            DateUtil.lstNames = new ArrayList<String>();
            for (ServiceBasicAttributeNames s : ServiceBasicAttributeNames.values()) {
                DateUtil.lstNames.add(s.getAttributeName());
            }
        }
    }

    public static List<String> getAttributeNames() {
        ServiceUtil.initList();
        return DateUtil.lstNames;
    }

    public static void initLogger(String path) {
        if (path == null) {
            return;
        }
        PropertyConfigurator.configure((String)path);
        LogManager l = LogManager.getLogManager();
        try {
            l.readConfiguration(new FileInputStream(new File(path)));
        }
        catch (SecurityException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            Log.logException((String)"", (Throwable)e);
        }
        catch (IOException e) {
            Log.logException((String)"", (Throwable)e);
        }
    }
}

