/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.glite.authz.pep.obligation.eesmap;

import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

import org.glite.authz.common.config.AbstractConfiguration;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Result;
import org.glite.authz.pep.obligation.ObligationHandler;

import org.ini4j.Ini;

public class EESObligationHandlerConfigurationParserTest extends TestCase {

    IniSectionConfigurationParser<ObligationHandler> parser;

    DummyConfigurationBuilder configBuilder;

    public static String INI_FILENAME= "ees-oh.ini";

    public static String INI_ERROR_FILENAME= "ees-oh_error.ini";

    public static String SECTION_NAME= "EES-OH";

    public static String PARSER_CLASSNAME= "org.glite.authz.pep.obligation.eesmap.EESObligationHandlerConfigurationParser";

    protected void setUp() throws Exception {
        @SuppressWarnings("unchecked")
        // parser
        Class<IniSectionConfigurationParser<ObligationHandler>> parserClass= (Class<IniSectionConfigurationParser<ObligationHandler>>) EESObligationHandlerConfigurationParser.class.getClassLoader().loadClass(PARSER_CLASSNAME);
        parser= parserClass.getConstructor().newInstance();
        // dummy config builder
        configBuilder= new DummyConfigurationBuilder();
    }

    private Ini loadIni(String filename) throws IOException {
        InputStream is= EESObligationHandlerConfigurationParser.class.getClassLoader().getResourceAsStream(filename);
        Ini ini= new Ini(is);
        return ini;

    }

    private Ini.Section getIniSection(String iniFilename, String sectionName)
            throws IOException {
        Ini ini= loadIni(iniFilename);
        Ini.Section section= ini.get(sectionName);
        return section;
    }

    public void testConfigurationParser() throws Exception {
        Ini.Section section= getIniSection(INI_FILENAME, SECTION_NAME);
        ObligationHandler oh= parser.parse(section, configBuilder);
    }

    private void configurationParserError(int i) throws Exception {
        Ini.Section section= getIniSection(INI_ERROR_FILENAME, SECTION_NAME
                + "_ERR" + i);
        try {
            ObligationHandler oh= parser.parse(section, configBuilder);
        } catch (ConfigurationException e) {
            System.out.println("EXPECTED ConfigurationException: "
                    + e.getMessage());
        }
    }

    public void testConfigurationParserErrors() throws Exception {
        configurationParserError(1);
        configurationParserError(2);
        configurationParserError(3);
    }

    public void testApplied() throws IOException, ConfigurationException {
        Ini.Section section= getIniSection(INI_FILENAME, SECTION_NAME);
        EESObligationHandler oh= (EESObligationHandler) parser.parse(section,
                                                                     configBuilder);
        Result result= createModelResult();
        assertTrue(oh.resultContainsHandledObligationId(result));
    }

    public void testMixObligationsInRequest() {
        
    }
    
    protected Result createModelResult() {
        Result result= new Result();
        Obligation obligation= new Obligation();
        obligation.setFulfillOn(Result.DECISION_PERMIT);
        obligation.setId("x-urn:test:myhandledobligationid");
        result.getObligations().add(obligation);
        return result;
    }

    class DummyConfiguration extends AbstractConfiguration {
        public DummyConfiguration() {
            super();
        }
    }

    class DummyConfigurationBuilder extends
            AbstractConfigurationBuilder<DummyConfiguration> {
        public DummyConfigurationBuilder() {
            super();
        }

        public DummyConfiguration build() {
            return new DummyConfiguration();
        }
    }

}
