/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.eesmap;

import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Status;
import org.glite.authz.common.model.StatusCode;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.model.util.Strings;
import org.opensaml.Configuration;
import org.opensaml.xacml.XACMLObjectBuilder;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceContentType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusMessageType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.policy.AttributeAssignmentType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xml.XMLObjectBuilder;

public class XACMLConverter {
    private static XACMLObjectBuilder<StatusCodeType> statusCodeBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusCodeType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<StatusType> statusBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusType.DEFAULT_ELEMENT_NAME);
    private static XMLObjectBuilder<StatusMessageType> statusMessageBuilder = Configuration.getBuilderFactory().getBuilder(StatusMessageType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ObligationsType> obligationsBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ObligationsType.DEFAULT_ELEMENT_QNAME);
    private static XACMLObjectBuilder<ObligationType> obligationBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ObligationType.DEFAULT_ELEMENT_QNAME);
    private static XACMLObjectBuilder<AttributeAssignmentType> attributeAssignmentBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(AttributeAssignmentType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResultType> resultBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResultType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<DecisionType> decisionBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(DecisionType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResponseType> responseBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResponseType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<AttributeType> attributeBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(AttributeType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<AttributeValueType> attributeValueBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(AttributeValueType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ActionType> actionBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ActionType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<EnvironmentType> environmentBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(EnvironmentType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResourceType> resourceBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResourceType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResourceContentType> resourceContentBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResourceContentType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<SubjectType> subjectBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(SubjectType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<RequestType> requestBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(RequestType.DEFAULT_ELEMENT_NAME);

    public static final Action actionFromXACML(ActionType actionType) {
        if (actionType == null) {
            return null;
        }
        Action action = new Action();
        if (actionType.getAttributes() != null) {
            for (AttributeType attributeType : actionType.getAttributes()) {
                action.getAttributes().add(XACMLConverter.attributeFromXACML(attributeType));
            }
        }
        return action;
    }

    public static final ActionType actionToXACML(Action action) {
        if (action == null) {
            return null;
        }
        ActionType actionType = (ActionType)actionBuilder.buildObject();
        if (action.getAttributes() != null) {
            for (Attribute attribute : action.getAttributes()) {
                actionType.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return actionType;
    }

    public static final Attribute attributeFromXACML(AttributeType attributeType) {
        if (attributeType == null) {
            return null;
        }
        Attribute attribute = new Attribute();
        attribute.setDataType(Strings.safeTrimOrNullString((String)attributeType.getDataType()));
        attribute.setId(Strings.safeTrimOrNullString((String)attributeType.getAttributeID()));
        attribute.setIssuer(Strings.safeTrimOrNullString((String)attributeType.getIssuer()));
        if (attributeType.getAttributeValues() != null) {
            for (AttributeValueType attributeValueType : attributeType.getAttributeValues()) {
                String string = attributeValueType.getValue();
                if (string == null) continue;
                attribute.getValues().add(Strings.safeTrimOrNullString((String)attributeValueType.getValue()));
            }
        }
        return attribute;
    }

    public static final AttributeType attributeToXACML(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        AttributeType attributeType = (AttributeType)attributeBuilder.buildObject();
        attributeType.setAttributeID(Strings.safeTrimOrNullString((String)attribute.getId()));
        String string = Strings.safeTrimOrNullString((String)attribute.getDataType());
        if (string != null) {
            attributeType.setDataType(string);
        } else {
            attributeType.setDataType("http://www.w3.org/2001/XMLSchema#string");
        }
        attributeType.setIssuer(Strings.safeTrimOrNullString((String)attribute.getIssuer()));
        if (attribute.getValues() != null) {
            for (Object e : attribute.getValues()) {
                String string2 = Strings.safeTrimOrNullString((String)e.toString());
                if (string2 == null) continue;
                AttributeValueType attributeValueType = (AttributeValueType)attributeValueBuilder.buildObject();
                attributeValueType.setValue(string2);
                attributeType.getAttributeValues().add(attributeValueType);
            }
        }
        return attributeType;
    }

    public static final Environment environmentFromXACML(EnvironmentType environmentType) {
        if (environmentType == null) {
            return null;
        }
        Environment environment = new Environment();
        if (environmentType.getAttributes() != null) {
            for (AttributeType attributeType : environmentType.getAttributes()) {
                environment.getAttributes().add(XACMLConverter.attributeFromXACML(attributeType));
            }
        }
        return environment;
    }

    public static final EnvironmentType environmentToXACML(Environment environment) {
        if (environment == null) {
            return null;
        }
        EnvironmentType environmentType = (EnvironmentType)environmentBuilder.buildObject();
        if (environment.getAttributes() != null) {
            for (Attribute attribute : environment.getAttributes()) {
                environmentType.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return environmentType;
    }

    public static final Obligation obligationFromXACML(ObligationType obligationType) {
        if (obligationType == null) {
            return null;
        }
        Obligation obligation = new Obligation();
        if (obligationType.getAttributeAssignments() != null) {
            for (AttributeAssignmentType attributeAssignmentType : obligationType.getAttributeAssignments()) {
                AttributeAssignment attributeAssignment = new AttributeAssignment();
                attributeAssignment.setAttributeId(Strings.safeTrimOrNullString((String)attributeAssignmentType.getAttributeId()));
                attributeAssignment.setDataType(Strings.safeTrimOrNullString((String)attributeAssignmentType.getDataType()));
                attributeAssignment.setValue(Strings.safeTrimOrNullString((String)attributeAssignmentType.getValue()));
            }
        }
        switch (obligationType.getFulfillOn()) {
            case Deny: {
                obligation.setFulfillOn(0);
                break;
            }
            case Permit: {
                obligation.setFulfillOn(1);
            }
        }
        obligation.setId(Strings.safeTrimOrNullString((String)obligationType.getObligationId()));
        return obligation;
    }

    public static final ObligationType obligationToXACML(Obligation obligation) {
        if (obligation == null) {
            return null;
        }
        ObligationType obligationType = (ObligationType)obligationBuilder.buildObject();
        if (obligation.getAttributeAssignments() != null) {
            for (AttributeAssignment attributeAssignment : obligation.getAttributeAssignments()) {
                attributeAssignment = (AttributeAssignment)obligation.getAttributeAssignments().get(0);
                AttributeAssignmentType attributeAssignmentType = (AttributeAssignmentType)attributeAssignmentBuilder.buildObject();
                attributeAssignmentType.setAttributeId(Strings.safeTrimOrNullString((String)attributeAssignment.getAttributeId()));
                attributeAssignmentType.setDataType(attributeAssignment.getDataType());
                attributeAssignmentType.setValue(attributeAssignment.getValue());
            }
        }
        if (obligation.getFulfillOn() == 1) {
            obligationType.setFulfillOn(EffectType.Permit);
        } else {
            obligationType.setFulfillOn(EffectType.Deny);
        }
        obligationType.setObligationId(Strings.safeTrimOrNullString((String)obligation.getId()));
        return obligationType;
    }

    public static final Request requestFromXACML(RequestType requestType) {
        Request request = new Request();
        request.setAction(XACMLConverter.actionFromXACML(requestType.getAction()));
        request.setEnvironment(XACMLConverter.environmentFromXACML(requestType.getEnvironment()));
        if (requestType.getResources() != null) {
            for (ResourceType resourceType : requestType.getResources()) {
                request.getResources().add(XACMLConverter.resourceFromXACML(resourceType));
            }
        }
        if (requestType.getSubjects() != null) {
            for (ResourceType resourceType : requestType.getSubjects()) {
                request.getSubjects().add(XACMLConverter.subjectFromXACML((SubjectType)resourceType));
            }
        }
        return request;
    }

    public static final RequestType requestToXACML(Request request) {
        if (request == null) {
            return null;
        }
        RequestType requestType = (RequestType)requestBuilder.buildObject();
        requestType.setAction(XACMLConverter.actionToXACML(request.getAction()));
        requestType.setEnvironment(XACMLConverter.environmentToXACML(request.getEnvironment()));
        if (request.getResources() != null) {
            for (Resource resource : request.getResources()) {
                requestType.getResources().add(XACMLConverter.resourceToXACML(resource));
            }
        }
        if (request.getSubjects() != null) {
            for (Resource resource : request.getSubjects()) {
                requestType.getSubjects().add(XACMLConverter.subjectToXACML((Subject)resource));
            }
        }
        return requestType;
    }

    public static final Resource resourceFromXACML(ResourceType resourceType) {
        if (resourceType == null) {
            return null;
        }
        Resource resource = new Resource();
        if (resourceType.getResourceContent() != null) {
            resource.setResourceContent(Strings.safeTrimOrNullString((String)resourceType.getResourceContent().getValue()));
        }
        if (resourceType.getAttributes() != null) {
            for (AttributeType attributeType : resourceType.getAttributes()) {
                resource.getAttributes().add(XACMLConverter.attributeFromXACML(attributeType));
            }
        }
        return resource;
    }

    public static final ResourceType resourceToXACML(Resource resource) {
        if (resource == null) {
            return null;
        }
        ResourceType resourceType = (ResourceType)resourceBuilder.buildObject();
        if (!Strings.isEmpty((String)resource.getResourceContent())) {
            ResourceContentType resourceContentType = (ResourceContentType)resourceContentBuilder.buildObject();
            resourceContentType.setValue(Strings.safeTrimOrNullString((String)resource.getResourceContent()));
            resourceType.setResourceContent(resourceContentType);
        }
        if (resource.getAttributes() != null) {
            for (Attribute attribute : resource.getAttributes()) {
                resourceType.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return resourceType;
    }

    public static final Response responseFromXACML(ResponseType responseType, RequestType requestType) {
        if (responseType == null) {
            return null;
        }
        Response response = new Response();
        response.getResults().add(XACMLConverter.resultFromXACML(responseType.getResult()));
        if (requestType != null) {
            response.setRequest(XACMLConverter.requestFromXACML(requestType));
        }
        return response;
    }

    public static final ResponseType responseToXACML(Response response) {
        if (response == null) {
            return null;
        }
        ResponseType responseType = (ResponseType)responseBuilder.buildObject();
        responseType.setResult(XACMLConverter.resultToXACML((Result)response.getResults().get(0)));
        return responseType;
    }

    public static final Result resultFromXACML(ResultType resultType) {
        if (resultType == null) {
            return null;
        }
        Result result = new Result();
        result.setResourceId(resultType.getResourceId());
        switch (resultType.getDecision().getDecision()) {
            case Deny: {
                result.setDecision(0);
                break;
            }
            case Indeterminate: {
                result.setDecision(2);
                break;
            }
            case NotApplicable: {
                result.setDecision(3);
                break;
            }
            case Permit: {
                result.setDecision(1);
            }
        }
        result.setStatus(XACMLConverter.statusFromXACML(resultType.getStatus()));
        if (resultType.getObligations() != null && resultType.getObligations().getObligations() != null) {
            for (ObligationType obligationType : resultType.getObligations().getObligations()) {
                result.getObligations().add(XACMLConverter.obligationFromXACML(obligationType));
            }
        }
        return result;
    }

    public static final ResultType resultToXACML(Result result) {
        if (result == null) {
            return null;
        }
        ResultType resultType = (ResultType)resultBuilder.buildObject();
        DecisionType decisionType = (DecisionType)decisionBuilder.buildObject();
        switch (result.getDecision()) {
            case 0: {
                decisionType.setDecision(DecisionType.DECISION.Deny);
                break;
            }
            case 2: {
                decisionType.setDecision(DecisionType.DECISION.Indeterminate);
                break;
            }
            case 3: {
                decisionType.setDecision(DecisionType.DECISION.NotApplicable);
                break;
            }
            case 1: {
                decisionType.setDecision(DecisionType.DECISION.Permit);
            }
        }
        resultType.setDecision(decisionType);
        resultType.setStatus(XACMLConverter.statusToXACML(result.getStatus()));
        if (result.getObligations() != null) {
            ObligationsType obligationsType = (ObligationsType)obligationsBuilder.buildObject();
            for (Obligation obligation : result.getObligations()) {
                obligationsType.getObligations().add(XACMLConverter.obligationToXACML(obligation));
            }
            resultType.setObligations(obligationsType);
        }
        return resultType;
    }

    public static final StatusCode statusCodeFromXACML(StatusCodeType statusCodeType) {
        if (statusCodeType == null) {
            return null;
        }
        StatusCode statusCode = new StatusCode();
        statusCode.setCode(Strings.safeTrimOrNullString((String)statusCodeType.getValue()));
        statusCode.setSubCode(XACMLConverter.statusCodeFromXACML(statusCodeType.getStatusCode()));
        return statusCode;
    }

    public static final StatusCodeType statusCodeToXACML(StatusCode statusCode) {
        if (statusCode == null) {
            return null;
        }
        StatusCodeType statusCodeType = (StatusCodeType)statusCodeBuilder.buildObject();
        statusCodeType.setValue(Strings.safeTrimOrNullString((String)statusCode.getCode()));
        statusCodeType.setStatusCode(XACMLConverter.statusCodeToXACML(statusCode.getSubCode()));
        return statusCodeType;
    }

    public static final Status statusFromXACML(StatusType statusType) {
        if (statusType == null) {
            return null;
        }
        Status status = new Status();
        status.setCode(XACMLConverter.statusCodeFromXACML(statusType.getStatusCode()));
        if (statusType.getStatusMessage() != null) {
            status.setMessage(Strings.safeTrimOrNullString((String)statusType.getStatusMessage().getValue()));
        }
        return status;
    }

    public static final StatusType statusToXACML(Status status) {
        if (status == null) {
            return null;
        }
        StatusType statusType = (StatusType)statusBuilder.buildObject();
        statusType.setStatusCode(XACMLConverter.statusCodeToXACML(status.getCode()));
        if (!Strings.isEmpty((String)status.getMessage())) {
            StatusMessageType statusMessageType = (StatusMessageType)statusMessageBuilder.buildObject(StatusMessageType.DEFAULT_ELEMENT_NAME, StatusMessageType.TYPE_NAME);
            statusMessageType.setValue(Strings.safeTrimOrNullString((String)status.getMessage()));
            statusType.setStatusMessage(statusMessageType);
        }
        return statusType;
    }

    public static final Subject subjectFromXACML(SubjectType subjectType) {
        if (subjectType == null) {
            return null;
        }
        Subject subject = new Subject();
        subject.setCategory(Strings.safeTrimOrNullString((String)subjectType.getSubjectCategory()));
        if (subjectType.getAttributes() != null) {
            for (AttributeType attributeType : subjectType.getAttributes()) {
                subject.getAttributes().add(XACMLConverter.attributeFromXACML(attributeType));
            }
        }
        return subject;
    }

    public static final SubjectType subjectToXACML(Subject subject) {
        if (subject == null) {
            return null;
        }
        SubjectType subjectType = (SubjectType)subjectBuilder.buildObject();
        subjectType.setSubjectCategory(Strings.safeTrimOrNullString((String)subject.getCategory()));
        if (subject.getAttributes() != null) {
            for (Attribute attribute : subject.getAttributes()) {
                subjectType.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return subjectType;
    }
}

