/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.eesmap;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.glite.authz.common.context.DecisionRequestContext;
import org.glite.authz.common.context.DecisionRequestContextHelper;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.util.DeepCopy;
import org.glite.authz.pep.obligation.BaseObligationHandler;
import org.glite.authz.pep.obligation.ObligationHandler;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.eesmap.EESObligationHandlerException;
import org.glite.authz.pep.obligation.eesmap.XACMLConverter;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.ws.soap.client.SOAPMessageContext;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.HttpSOAPClient;
import org.opensaml.ws.soap.common.SOAPException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EESObligationHandler
extends BaseObligationHandler
implements ObligationHandler {
    private final Logger log = LoggerFactory.getLogger(EESObligationHandler.class);
    private String entityId;
    private String eesEndpoint;
    static final String SPECIAL_EES_OBLIGATION_LIST_ATTR_ID = "http://authz-interop.org/xacml/attribute/trans-obligation";
    private HttpSOAPClient soapClient;

    public EESObligationHandler(String string, String string2, String string3) {
        super(string, string2);
        this.eesEndpoint = string3;
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.setNamespaceAware(true);
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        this.soapClient = new HttpSOAPClient(httpClientBuilder.buildClient(), (ParserPool)basicParserPool);
    }

    public void setEntityId(String string) {
        this.entityId = string;
    }

    protected Request mixObligationsInRequest(Request request, Result result) {
        ListIterator listIterator = result.getObligations().listIterator();
        ListIterator listIterator2 = null;
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        Obligation obligation = null;
        String string = null;
        Request request2 = null;
        try {
            Attribute attribute;
            while (listIterator.hasNext()) {
                attribute = new Attribute();
                obligation = (Obligation)listIterator.next();
                listIterator2 = obligation.getAttributeAssignments().listIterator();
                attribute.setId(SPECIAL_EES_OBLIGATION_LIST_ATTR_ID);
                attribute.getValues().add(obligation.getId());
                attribute.setIssuer(this.getEntityId());
                hashSet.add(attribute);
                while (listIterator2.hasNext()) {
                    AttributeAssignment attributeAssignment = (AttributeAssignment)listIterator2.next();
                    Attribute attribute2 = new Attribute();
                    string = URLEncoder.encode(obligation.getId(), "UTF-8") + "?attrId=" + URLEncoder.encode(attributeAssignment.getAttributeId(), "UTF-8");
                    attribute2.setId(string);
                    attribute2.setDataType(attributeAssignment.getDataType());
                    attribute2.setIssuer(this.getEntityId());
                    attribute2.getValues().add(attributeAssignment.getValue());
                    hashSet.add(attribute2);
                }
            }
            request2 = (Request)DeepCopy.copy((Object)request);
            attribute = request2.getEnvironment();
            attribute.getAttributes().addAll(hashSet);
        }
        catch (Exception exception) {
            this.log.error("EES ObligationHandler could not add in PDP obligations into EES request", (Throwable)exception);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Request after EES mix in of result\n{}", (Object)request2.toString());
        }
        return request2;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEESEndpoint() {
        return this.eesEndpoint;
    }

    public boolean evaluateObligation(Request request, Result result) throws ObligationProcessingException {
        if (!this.resultContainsHandledObligationId(result)) {
            return false;
        }
        Request request2 = this.mixObligationsInRequest(request, result);
        DecisionRequestContext decisionRequestContext = DecisionRequestContextHelper.buildMessageContext((String)this.getEntityId());
        this.sendRequestToEES(decisionRequestContext, request2);
        Response response = this.extractResponseFromMessageContext(decisionRequestContext);
        Result result2 = (Result)response.getResults().get(0);
        Iterator iterator = result.getObligations().iterator();
        ArrayList<Obligation> arrayList = new ArrayList<Obligation>();
        while (iterator.hasNext()) {
            Obligation obligation = (Obligation)iterator.next();
            if (!this.getObligationId().equals(obligation.getId())) continue;
            arrayList.add(obligation);
        }
        result.getObligations().removeAll(arrayList);
        result.getObligations().addAll(result2.getObligations());
        return true;
    }

    protected boolean resultContainsHandledObligationId(Result result) {
        for (Obligation obligation : result.getObligations()) {
            if (!this.getObligationId().equals(obligation.getId())) continue;
            return true;
        }
        this.log.debug("Result doesn't contain the handled obligationId: {}", (Object)this.getObligationId());
        return false;
    }

    protected Response extractResponseFromMessageContext(DecisionRequestContext decisionRequestContext) throws EESObligationHandlerException {
        Envelope envelope = (Envelope)decisionRequestContext.getInboundMessage();
        if (envelope != null) {
            this.traceSOAPMessage(envelope, false);
            if (!envelope.getBody().getOrderedChildren().isEmpty()) {
                org.opensaml.saml2.core.Response response = (org.opensaml.saml2.core.Response)envelope.getBody().getOrderedChildren().get(0);
                if (!response.getAssertions().isEmpty()) {
                    Assertion assertion = (Assertion)response.getAssertions().get(0);
                    List list = assertion.getStatements(XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
                    if (!list.isEmpty()) {
                        XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType = (XACMLAuthzDecisionStatementType)list.get(0);
                        ResponseType responseType = xACMLAuthzDecisionStatementType.getResponse();
                        if (responseType == null) {
                            String string = "No XACML Response found in Authorization Decision Statement";
                            this.log.error(string);
                            throw new EESObligationHandlerException(string);
                        }
                        RequestType requestType = xACMLAuthzDecisionStatementType.getRequest();
                        return XACMLConverter.responseFromXACML(responseType, requestType);
                    }
                    String string = "No XACML Authorization Decision Statement found in SAML Assertion";
                    this.log.error(string);
                    throw new EESObligationHandlerException(string);
                }
                String string = "No SAML Assertion found in SAML Response";
                this.log.error(string);
                throw new EESObligationHandlerException(string);
            }
            String string = "No SAML Reponse found in SOAP Body";
            this.log.error(string);
            throw new EESObligationHandlerException(string);
        }
        String string = "No inbound SOAP Envelope found in message context";
        this.log.error(string);
        throw new EESObligationHandlerException(string);
    }

    protected void sendRequestToEES(DecisionRequestContext decisionRequestContext, Request request) throws EESObligationHandlerException {
        RequestType requestType = XACMLConverter.requestToXACML(request);
        Envelope envelope = DecisionRequestContextHelper.buildSOAPMessage((String)this.getEntityId(), (DecisionRequestContext)decisionRequestContext, (RequestType)requestType);
        this.traceSOAPMessage(envelope, true);
        try {
            this.log.debug("Send request {} to EES {}", (Object)decisionRequestContext.getOutboundMessageId(), (Object)this.getEESEndpoint());
            this.soapClient.send(this.getEESEndpoint(), (SOAPMessageContext)decisionRequestContext);
        }
        catch (SOAPException sOAPException) {
            String string = "Error sending SOAP message to the EES " + this.eesEndpoint + ": " + sOAPException.toString();
            this.log.error(string);
            throw new EESObligationHandlerException(string, (Exception)((Object)sOAPException));
        }
        catch (SecurityException securityException) {
            String string = "Error sending SOAP message to the EES " + this.eesEndpoint + ": " + securityException.toString();
            this.log.error(string);
            throw new EESObligationHandlerException(string, (Exception)((Object)securityException));
        }
    }

    private void traceSOAPMessage(Envelope envelope, boolean bl) {
        if (this.log.isTraceEnabled()) {
            try {
                Element element = Configuration.getMarshallerFactory().getMarshaller((XMLObject)envelope).marshall((XMLObject)envelope);
                if (bl) {
                    this.log.trace("Outgoing SOAP message\n{}", (Object)XMLHelper.prettyPrintXML((Node)element));
                } else {
                    this.log.trace("Incoming SOAP message\n{}", (Object)XMLHelper.prettyPrintXML((Node)element));
                }
            }
            catch (MarshallingException marshallingException) {
                this.log.error("Unable to marshall SOAP message: {}", (Object)marshallingException.getMessage());
            }
        }
    }
}

