/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation;

import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.obligation.ObligationHandler;

public abstract class BaseObligationHandler
implements ObligationHandler {
    private String id_;
    private String obligationId_;
    private int precedence_;

    protected BaseObligationHandler(String string) {
        this(string, string);
    }

    protected BaseObligationHandler(String string, String string2) {
        this(string, string2, 0);
    }

    protected BaseObligationHandler(String string, String string2, int n) {
        this.setId(string);
        this.obligationId_ = Strings.safeTrimOrNullString((String)string2);
        if (this.obligationId_ == null) {
            throw new IllegalArgumentException("Provided obligation ID may not be null or empty");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Handler precedence must be 0 or greater");
        }
        this.precedence_ = n;
    }

    public String getObligationId() {
        return this.obligationId_;
    }

    public int getHandlerPrecedence() {
        return this.precedence_;
    }

    public String getId() {
        return this.id_;
    }

    protected void setId(String string) {
        String string2 = Strings.safeTrimOrNullString((String)string);
        if (string2 == null) {
            throw new IllegalArgumentException("Obligation Handler ID may not be null or empty");
        }
        this.id_ = string2;
    }

    public int hashCode() {
        return this.getObligationId().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ObligationHandler) {
            return Strings.safeEquals((Object)this.getObligationId(), (Object)((ObligationHandler)object).getObligationId());
        }
        return false;
    }
}

