#!/bin/bash

success=1
fail1=0
fail2=0
defport=6217
defhost=127.0.0.1
verbose=0
usage=0

host=$defhost
port=$defport

# Prints usage message
usage() {
    echo "Usage: $PROG [options]"
    echo
    echo "Options:"
    echo " -P <port>          specify port, default $defport"
    echo " -H <host>[:port]   specify host (and port), default $defhost"
    echo " -s                 run success test, default yes"
    echo " -f                 run failure test1, default no"
    echo " -F                 run failure test1, default no"
    echo " -a                 run all tests, default no"
    echo " -h                 print this help"
    echo " -v                 verbose mode"
    echo
}

# Parse command line options
while getopts ":sfFahvP:H:" i ; do
    case "$i" in
	s)  success=1; fail1=0; fail2=0 ;;
	f)  success=0; fail1=1; fail2=0 ;;
	F)  success=0; fail1=0; fail2=1 ;;
	a)  success=1; fail1=1; fail2=1 ;;
	P)  port="$OPTARG" ;;
	H)  echo $OPTARG|grep -q : && {
		host=$(echo $OPTARG|cut -d: -f1)
		port=$(echo $OPTARG|cut -d: -f2)
	    } || {
		host=$OPTARG
	    } ;;
	h)  usage; exit 0 ;;
	v)  verbose=1 ;;
	:)  echo "$PROG: option requires an argument -- '$OPTARG'" >&2
	    echo "Try \`$PROG -h' for more information." >&2
	    exit 1 ;;
	?)  echo "$PROG: invalid option -- '$OPTARG'" >&2
	    echo "Try \`$PROG -h' for more information." >&2
	    exit 1 ;;
    esac
done


# Configuration

xml_pretty=xml_pp

mesg()	{
    date=$(date -u +%FT%TZ)
    issuer="$(basename $0)@$(hostname -f)"
    seed=$(date +%N)
#    rand=$(awk "BEGIN {srand($seed); print int(1e9*rand()) }")
#    uuid=$(printf "ID-%09d\n" $rand)
    rand=$(openssl rand -base64 9)
    uuid=$(printf "ID-%12s" $rand)
    printf "  issuer=%s\n      ID=%s\n" $issuer $uuid >&2

    cat << EOF
<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:dsig="http://www.w3.org/2000/09/xmldsig#" xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion" xmlns:XACMLcontext="urn:oasis:names:tc:xacml:2.0:context:schema:os" xmlns:XACMLassertion="urn:oasis:names:tc:xacml:2.0:profile:saml2.0:v2:schema:assertion" xmlns:XACMLpolicy="urn:oasis:names:tc:xacml:2.0:policy:schema:os" xmlns:xenc="http://www.w3.org/2001/04/xmlenc#" xmlns:XACMLService="http://www.globus.org/security/XACMLAuthorization/bindings" xmlns:XACMLsamlp="urn:oasis:names:tc:xacml:2.0:profile:saml2.0:v2:schema:protocol" xmlns:samlp="urn:oasis:names:tc:SAML:2.0:protocol">
<SOAP-ENV:Body>
<XACMLsamlp:XACMLAuthzDecisionQuery CombinePolicies="true" ReturnContext="true" InputContextOnly="false" IssueInstant="$date" Version="2.0" ID="$uuid">
<saml:Issuer xsi:type="saml:NameIDType" Format="urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName">$issuer</saml:Issuer>

<XACMLcontext:Request xsi:type="XACMLcontext:RequestType">

<XACMLcontext:Action xsi:type="XACMLcontext:ActionType">
</XACMLcontext:Action>
$1
</XACMLcontext:Request>

</XACMLsamlp:XACMLAuthzDecisionQuery>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
EOF
}

ENV_SUCCESS='<XACMLcontext:Environment xsi:type="XACMLcontext:EnvironmentType">
<XACMLcontext:Attribute AttributeId="http://authz-interop.org/xacml/attribute/trans-obligation" DataType="http://www.w3.org/2001/XMLSchema#string" Issuer="http://localhost/pepd/ees" xsi:type="XACMLcontext:AttributeType">
<XACMLcontext:AttributeValue xsi:type="XACMLcontext:AttributeValueType">http://example.org/xacml/obligation/incoming-obligation</XACMLcontext:AttributeValue>
</XACMLcontext:Attribute>
<XACMLcontext:Attribute AttributeId="http://example.org/xacml/obligation/incoming-obligation?attrId=http%3A%2F%2Fexample.org%2Fxacml%2Ftest-attribute" DataType="http://www.w3.org/2001/XMLSchema#string" Issuer="http://localhost/pepd/ees" xsi:type="XACMLcontext:AttributeType">
<XACMLcontext:AttributeValue xsi:type="XACMLcontext:AttributeValueType">input-value</XACMLcontext:AttributeValue>
</XACMLcontext:Attribute>
<XACMLcontext:Attribute AttributeId="http://example.org/xacml/obligation/incoming-obligation?attrId=http%3A%2F%2Fexample.org%2Fxacml%2Ftest-attribute2" DataType="http://www.w3.org/2001/XMLSchema#string" Issuer="http://localhost/pepd/ees" xsi:type="XACMLcontext:AttributeType">
<XACMLcontext:AttributeValue xsi:type="XACMLcontext:AttributeValueType">input-value2</XACMLcontext:AttributeValue>
</XACMLcontext:Attribute>
</XACMLcontext:Environment>'

ENV_FAILURE='<XACMLcontext:Environment xsi:type="XACMLcontext:EnvironmentType">
<XACMLcontext:Attribute AttributeId="http://authz-interop.org/xacml/attribute/trans-obligation" DataType="http://www.w3.org/2001/XMLSchema#string" Issuer="http://localhost/pepd/ees" xsi:type="XACMLcontext:AttributeType">
<XACMLcontext:AttributeValue xsi:type="XACMLcontext:AttributeValueType">http://example.org/xacml/obligation/incoming-obligation</XACMLcontext:AttributeValue>
</XACMLcontext:Attribute>
</XACMLcontext:Environment>'

# test for ${xml_pretty}
if type ${xml_pretty} > /dev/null 2>&1 ;then
    have_xml_pretty=1
else
    have_xml_pretty=0
fi

# Takes three args, a test string and a pattern to match to
test_main() {
    if [ $verbose -eq 1 ];then
	if [ $have_xml_pretty -eq 1 ];then
	    curl -v -d "$1" http://${host}:$port | ${xml_pretty}
	else
	    curl -v -d "$1" http://${host}:$port
	fi
    else
	if [ $have_xml_pretty -eq 1 ];then
	    curl -v -d "$1" http://${host}:$port | ${xml_pretty}
	else
	    curl -v -d "$1" http://${host}:$port
	fi
    fi
}

if [ $success -eq 1 ];then
    echo "Basic sanity test:"
    test_main "$(mesg "$ENV_SUCCESS")"
    echo ;echo
fi

if [ $fail1 -eq 1 ];then
    echo "Basic failure test 1:"
    test_main "$(mesg "$ENV_FAILURE")"
    echo ;echo
fi

if [ $fail2 -eq 1 ];then
    echo "Basic failure test 2:"
    test_main "<TEST>"
    echo ;echo
fi
