/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#define _MULTI_THREADED
#define NUM_THREADS 40

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include "eef/eef_log.h"
#include "eef/eef_polytypes.h"

typedef struct foo_s {
  char* bar;  
} foo_t;

typedef struct list_s {
  foo_t* next;
} list_t;

static pthread_key_t    _key;
static pthread_once_t   _key_once = PTHREAD_ONCE_INIT;

void* tls_run(void* foo);
list_t* get_storage(void);
void prepare_tls(void);
void free_tls_key(void*);
void clean_tls(list_t* list);

list_t* get_storage(){
  list_t* list = NULL;
  if(!(list = pthread_getspecific(_key))) {
    if((list = calloc(1, sizeof(list_t)))){
      if((list->next = calloc(1, sizeof(foo_t)))){
        EEF_log(LOG_DEBUG, "Created new TLS at %p\n", (void*)list);
      }
    }
  } else {
    EEF_log(LOG_DEBUG, "Found existing TLS at %p\n", (void*)list);
  }

  return list;
}

void* tls_run(void* foo){
  list_t* list = get_storage(); 
  clean_tls(list);
  return NULL;
}

void prepare_tls(){
  pthread_key_create(&_key, free_tls_key);
}

void free_tls_key(void* list){
  free(list);
}

void clean_tls(list_t* list){
  free(list->next);
  free(list);
}

int main (int argc, char* argv[]){
  pthread_t threads[NUM_THREADS];
  long t;
  int rc;
  void* status;

  /*sleep(10);*/

  pthread_once(&_key_once, prepare_tls);

  for(t=0; t < NUM_THREADS; t++){
    EEF_log(LOG_DEBUG, "Creating thread %li!\n", t);
    rc = pthread_create(&threads[t], NULL, tls_run, (void*)(t));
    rc = pthread_join(threads[t], &status);
  }

  /*sleep(10);*/

  EEF_log(LOG_NOTICE, "EEF terminated!\n");

  /*sleep(10);*/

  pthread_exit(NULL);
  return 0;
}


