/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <stdio.h>

#include "aos_service.h"
#include "eef/eef_library.h"
#include "eef/eef_aos.h"
#include "eef/eef_log.h"

int main (int argc, char* argv[]){
  aos_context_t* context = NULL;
  aos_attribute_t* attribute = NULL;

  EEF_set_log_file("/tmp/mini_aos_test");
  EEF_set_log_ident("mini_aos_test");
  EEF_set_debug_mode(1);

  AOS_Init();

  rewindContexts(ANY);
  while((context = getNextContext(ANY))){
    printf("Got context: %p\n", (void*) context); 
  }

  context = createContext(NONE);
  printf("Made context: %p\n", (void*) context);

  addContext(context);
  printf("Added context: %p\n", (void*) context);

  if((attribute = createAttribute())){
    printf("Created attribute: %p\n", (void*) attribute);
    setAttributeId(attribute, "Bla");
    setAttributeValue(attribute, "Foo", 4);
    addAttribute(context, attribute);
    printf("Added attribute %p to context %p\n", (void*) attribute, (void*) context);
  }


  AOS_dump(LOG_NOTICE);
  
  AOS_Term();
  EEF_log(LOG_NOTICE, "Mini AOS test terminated!\n");
  EEF_closelog();

}
