/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#define _MULTI_THREADED
#define NUM_THREADS 40

#include "ees_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

#include "xacml.h"
#include "xacml_server.h"
#include "eics/eics_http.h"
#include "aos_service.h"
#include "eef/eef_library.h"
#include "eef/eef_log.h"
#include "eef/eef_aos.h"

#define PORT 1234 

static void signal_handler(int);


static void signal_handler(int sig){
  switch(sig){
    case SIGHUP:
      EEF_log(LOG_NOTICE, "Got SIGHUP - restart\n");
      EEF_term();
      break;
    case SIGTERM:
      EEF_log(LOG_NOTICE, "Got SIGTERM - shutting down\n");
      AOS_Clean();
      EEF_term();
      exit(0);
  }
}

int main (int argc, char* argv[]){
  char* config_file;                      /* config file path */
  aos_context_t*   _context;
  aos_attribute_t *_uid, *_gid;

  char* _uid_str = "1234";
  char* _gid_str = "1234";


  if(argc > 1){
    config_file = argv[1];
  } else {
    config_file = "examples/example_1.pdl";
  }
  EEF_set_config_file(config_file);

#ifdef ENABLE_DEBUG
  EEF_daemonize();
  /*daemon(0,0);*/
#endif

  signal(SIGHUP, signal_handler); /* catch hangup signal */
  signal(SIGTERM, signal_handler); /* catch kill signal */

  /* reuse this part when implementing SIGHUP */
  EEF_log(LOG_INFO, "Parsing config file %s\n", config_file);
	if(EEF_init() == EES_FAILURE){
    EEF_log(LOG_ERR, "Failed to parse config file (%s), exiting...\n", config_file);
  } else {
    /*make_socket();*/
    /* fill aos */
    _uid = createAttribute();
    _gid = createAttribute();

    setAttributeId(_uid, "posix-uid");
    setAttributeValue(_uid, _uid_str, strlen(_uid_str));
    setAttributeId(_gid, "posix-gid");
    setAttributeValue(_gid, _gid_str, strlen(_gid_str));

    if((_context = createContext(OBLIGATION)) != NULL){
      setContextObligationId(_context, "uidgid");

      addAttribute(_context, _uid);
      addAttribute(_context, _gid);

      addContext(_context);
    }
    AOS_dump(LOG_INFO);
    AOS_start_threading();
    set_xacml_http_port(PORT);
    start_xacml_http_server();
    /* start threading */
    /*for(t=0; t < NUM_THREADS; t++){*/
    /*printf("Creating thread %li!\n", t);*/
    /*rc = pthread_create(&threads[t], NULL, (void*)(void*) EEF_Run, (void*)(t));*/
    /*rc = pthread_join(threads[t], &status);*/

    /**//*Fire up SAML2-XACML2 */
    /**//*start_xacml_http_server(PORT);*/

    /*}*/
  }
  EEF_log(LOG_INFO, "EEF terminated!\n");

  AOS_dump(LOG_INFO);
  /*pthread_exit(NULL);*/

  return 0;
}


