/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "eef/eef_library.h"
#include "eef/eef_aos.h"
#include "eef/eef_log.h"

/*#define NUMBER_OF_ALLOWED_POLICIES 0*/

int main (int argc, char* argv[]){
  char* config_file;
  if(argc > 1){
    config_file = argv[1];
  } else {
    config_file = "examples/example_1.pdl";
  }
  EEF_set_config_file(config_file);

  EEF_set_log_file("/tmp/test_app_log");
  EEF_set_debug_mode(1);

  EEF_log(LOG_INFO, "Parsing config file %s\n", config_file);

  if(EEF_init() == EES_FAILURE){
    EEF_log(LOG_ERR, "Failed to parse config file (%s), exiting...\n", config_file);
  } else {

    EEF_log(LOG_INFO, "Modules path: %s\n", EEF_get_modules_path());
    /*setObligation("test", "foobar");*/
    if(EEF_run(NULL) == EES_FAILURE){
      EEF_log(LOG_ERR, "Failed to load and initialize all plugins in config file (%s), exiting...\n", config_file);
    }
    AOS_dump(LOG_INFO);
  }
  EEF_term();
  EEF_closelog();
  return 0;
}
