/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#define _MULTI_THREADED
#define NUM_THREADS 9001

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#include "aos_service.h"
#include "eef/eef_library.h"
#include "eef/eef_aos.h"
#include "eef/eef_log.h"

EES_RC add_dummy_aos_obligation(void);      /* adds some stuff to the AOS */
int aos_run_wrapper(void);

/**
 * Adds some dummy uid/gid obligations in the AOS
 */
EES_RC add_dummy_aos_obligation(void){
	aos_context_t   *_context, *_another_context;
	aos_attribute_t *_uid, *_gid;

	char* _uid_str = "1234";
	char* _gid_str = "1234";

  /*fill aos */
  _uid = createAttribute();
  _gid = createAttribute();

  setAttributeId(_uid, "posix-uid");
  setAttributeValue(_uid, _uid_str, strlen(_uid_str));
  setAttributeId(_gid, "posix-gid");
  setAttributeValue(_gid, _gid_str, strlen(_gid_str));

  if((_context = createContext(OBLIGATION)) != NULL){
    setContextObligationId(_context, "uidgid");

    addAttribute(_context, _uid);
    addAttribute(_context, _gid);

    addContext(_context);
  }
  if((_another_context = createContext(ANY)) != NULL){
    addContext(_another_context);
  }
  return EES_SUCCESS;
}

int aos_run_wrapper(void){
  pthread_detach(pthread_self());
  EEF_run(NULL);
  pthread_exit(NULL);
}

int main (int argc, char* argv[]){
  char* config_file;
  pthread_t threads[NUM_THREADS];
  long t;
  int rc;

  /*sleep(10);*/

  if(argc > 1){
    config_file = argv[1];
  } else {
    config_file = "examples/example_1.pdl";
  }
  EEF_set_config_file(config_file);

  EEF_set_log_file("/tmp/aos_threading_test_log");
  EEF_set_debug_mode(1);

  /* reuse this part when implementing SIGHUP */
  EEF_log(LOG_INFO, "Parsing config file %s\n", config_file);
  if(EEF_init() == EES_FAILURE){
    EEF_log(LOG_ERR, "Failed to parse config file (%s), exiting...\n", config_file);
  } else {

    add_dummy_aos_obligation();
    /*EEF_run();*/
    /*AOS_dump(LOG_INFO);*/
    AOS_start_threading();
    /* start threading */
    for(t=0; t < NUM_THREADS; t++){
      printf("Creating thread %li!\n", t);
      rc = pthread_create(&threads[t], NULL, (void * (*)(void *)) aos_run_wrapper, (void*)(t));
      EEF_log(LOG_ERR, "Error creating thread: %s\n", strerror(rc));
    }
  }
  /*sleep(10);*/
  /*AOS_Clean();*/
  if(EEF_term() == EES_SUCCESS){
    EEF_log(LOG_NOTICE, "EEF terminated!\n");
  } else {
    EEF_log(LOG_ERR, "Error while terminating EEF!\n");
  }
  EEF_closelog();

  /*sleep(10);*/

  pthread_exit(NULL);
  return 0;
}

