/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

%{

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "eval_manager.h"
#include "eef/eef_log.h"
%}

%union {
  record_t* record;
  rule_t*   rule;
};

%token<record> LABEL PORTVAR SENDVAR RECEIVEVAR ACCEPTVAR LEVELVAR NUMVAL FACILITYVAR LOGFACILITY LOGVAR TERM POLICYVAR POLICIES TRANS EMPTYLINE COMMENT PVAR PATH STRING
%type<record>  config var_list var policy_list string
%type<rule> policy rule;

%token-table

%nonassoc LABEL

%%

config:         /*  empty  */             { EEF_log(LOG_WARNING, "%s: Config file is empty.\n", __func__); }
              | var_list policy_list
              | policy_list
              | var_list                  { EEF_log(LOG_ERR, "%s: Config file contains no policy rules.\n", __func__); }
;


var_list:       var
              | var_list var
;

var:            PORTVAR '=' NUMVAL    	  { set_pdl_port($3); }
              | SENDVAR '=' NUMVAL        { set_pdl_send_timeout($3); }
              | RECEIVEVAR '=' NUMVAL     { set_pdl_receive_timeout($3); }
              | ACCEPTVAR '=' NUMVAL      { set_pdl_accept_timeout($3); }
              | PVAR '=' PATH             { set_pdl_modules_path($3);         }
              | PVAR '='                  { EEF_log(LOG_NOTICE, "%s: No value assigned to path. Using %s as path instead.\n", __func__, EES_MOD_HOME); }
              | LEVELVAR '=' NUMVAL       { set_pdl_log_level($3); }
              | FACILITYVAR '=' LOGFACILITY  { set_pdl_log_facility($3); }
	      |	LOGVAR  '=' PATH          { set_pdl_log_file($3); }
	      |	LOGVAR  '='               { EEF_log(LOG_NOTICE, "%s: No value assigned to log. Not using a separate log file.\n", __func__); }
	      | POLICYVAR '=' POLICIES    { set_pdl_policynames($3); }
	      |	TERM  '=' string          { add_variable($1, $3); }
              | TERM  '=' TERM            { add_variable($1, $3); }
;

string:         STRING                    { $$ = $1;                     }
              | string STRING             { $$ = concat_strings_with_space($1, $2); }
;

policy_list:    LABEL policy              { add_policy($1, $2); }
              | policy_list LABEL policy  { add_policy($2, $3); }
              | policy_list LABEL         { EEF_log(LOG_WARNING, "%s: expecting rule definitions.\n", __func__);
                                            EEF_log(LOG_WARNING, "%s: no rules specified for policy: '%s' at line %d.\n", __func__, $2->string, $2->lineno);
                                            remove_policy($2);
                                          }
              | LABEL                     { EEF_log(LOG_WARNING, "%s: expecting rule definitions.\n", __func__);
                                            EEF_log(LOG_WARNING, "%s: no rules specified for policy: '%s' at line %d.\n", __func__, $1->string, $1->lineno);
                                            remove_policy($1);
                                          }
;

policy:         rule                      { $$ = $1; }
              | policy rule               { $$ = $1; }
;

rule:           TERM                      { $$ = add_rule($1, NULL, NULL); }
              | TERM TRANS TERM           { $$ = add_rule($1, $3,  NULL); }
              | TERM TRANS TERM '|' TERM  { $$ = add_rule($1, $3, $5); }
              | '~' TERM TRANS TERM       { $$ = add_rule($2,  NULL, $4); }
;

%%

void set_yylval(record_t* r) {
  yylval.record = r;
}

/* Our pdl_yyparse() is just a wrapper around yyparse() */
int pdl_yyparse (void)	{
    return yyparse();
}
