/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <string.h>

#include "eef/eef_plugin.h"
#include "eef/eef_log.h"
#include "eef/eef_aos.h"
#include "eef/eef_polytypes.h"


/************************************************************************
 * Defines
 ************************************************************************/

/* Defines plugin name to be used in logs */
#define PLUGIN_NAME	"example_plugin"


/************************************************************************
 * Public functions
 ************************************************************************/

/* Plugin initialization function */
EES_PL_RC plugin_initialize(int argc, char* argv[]) {
    EEF_log(LOG_INFO, "%s: plugin initialized\n", PLUGIN_NAME);

    return EES_PL_SUCCESS;
}


/* Plugin run function */
EES_PL_RC plugin_run(void) {
    const char *obligation_id	="my_obligation";
    const char *attribute_id	="my_attribute_id";
    const char *attribute_value	="my_attribute_val";

    aos_context_t    *_context        = NULL;
    aos_attribute_t  *_tmp_attr       = NULL;

    /* Create obligation context */
    if ((_context = createContext(OBLIGATION)) == NULL) {
	EEF_log(LOG_ERR,
		"%s: Error, cannot create obligation context\n", PLUGIN_NAME);
	return EES_PL_FAILURE;
    }

    /* Set obligation ID */
    if ( setContextObligationId(_context, obligation_id) == EES_FAILURE ) {
	EEF_log(LOG_ERR, "%s: Error, cannot set obligation_id %s\n",
		PLUGIN_NAME, obligation_id);
	return EES_PL_FAILURE;
    }

    /* Create attribute */
    if ( (_tmp_attr = createAttribute()) == NULL) {
	EEF_log(LOG_ERR,
		"%s: Error, cannot create attribute\n", PLUGIN_NAME);
	return EES_PL_FAILURE;
    }

    /* Set attribute ID and value */
    if (setAttributeId(_tmp_attr, attribute_id) == EES_FAILURE ||
	setAttributeValue(_tmp_attr,
			  attribute_value,
			  strlen(attribute_value)+1) == EES_FAILURE)	{
	EEF_log(LOG_ERR, "%s: Error, cannot set attribute %s = %s\n",
		PLUGIN_NAME, attribute_id, attribute_value);
	return EES_PL_FAILURE;
    }


    /* Log */
    EEF_log(LOG_INFO,
	    "%s: Adding obligation %s with attribute %s=%s\n",
	    PLUGIN_NAME, obligation_id, attribute_id, attribute_value);

    /* Add attribute to the obligation */
    addAttribute(_context, _tmp_attr);

    /* Add obligation context to AOS */
    addContext(_context);

    EEF_log(LOG_INFO, "%s: plugin succeeded\n", PLUGIN_NAME);

    return EES_PL_SUCCESS;
}


/* Plugin termination function */
EES_PL_RC plugin_terminate(void){
    EEF_log(LOG_INFO, "%s: plugin terminated\n", PLUGIN_NAME);
    
    return EES_PL_SUCCESS;
}
