/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "eef/eef_plugin.h"
#include "eef/eef_aos.h"
#include "eef/eef_log.h"

/************************************************************************
 * Defines
 ************************************************************************/

/* Defines plugin name to be used in logs */
#define PLUGIN_NAME	"ees_dump_aos"


/************************************************************************
 * Global variables
 ************************************************************************/

/* Loglevel to use, can be overridden using cmdline option --loglevel */
static int loglevel=LOG_NOTICE;


/************************************************************************
 * Public functions
 ************************************************************************/

/* Initialize function */
EES_PL_RC plugin_initialize(int argc, char* argv[]){
    int i;
    size_t len;
    long longval;
    char *endptr,*pos;

    /* Parse its command line options */
    for (i=1; i<argc; i++)  {
	/* Find = sign */
	if ( (pos=strchr(argv[i],'=')) == NULL || pos[1]=='\0')    {
	    EEF_log(LOG_ERR, "%s: option does not have a value: %s\n",
		    PLUGIN_NAME, argv[i]);
	    return EES_PL_FAILURE;
	}
	/* find len of option itself */
	len=strlen(argv[i])-strlen(pos);
	/* start of value */
	pos++;
	/* Is it a valid option */
	if (strncmp(argv[i],"--loglevel",len)==0 ||
	    strncmp(argv[i], "-loglevel",len)==0)
	{
	    errno=0;
	    longval=strtol(pos, &endptr, 10);
	    if (errno || *endptr!='\0' || longval<0 || longval>5)	{
		EEF_log(LOG_ERR,
			"%s: value %s is not a valid loglevel [0-5]\n",
			PLUGIN_NAME, pos);
		return EES_PL_FAILURE;
	    }
	    /* Set loglevel and skip over value argument, do check rest of
	     * cmdline for invalid values */
	    EEF_log(LOG_INFO,"%s: will dump AOS on loglevel %ld\n",
		    PLUGIN_NAME, longval);
	    loglevel=LOG_CRIT+(int)longval;
	    i++;
	} else {
	    EEF_log(LOG_ERR, "%s: unknown option %s\n",
		    PLUGIN_NAME, argv[i]);
	    return EES_PL_FAILURE;
	}
    }

    EEF_log(LOG_INFO, "%s: plugin initialized\n", PLUGIN_NAME);
    return EES_PL_SUCCESS;
}

/* Run function */
EES_PL_RC plugin_run() {
    EEF_log(LOG_INFO, "%s: plugin running\n", PLUGIN_NAME);
    /* Dump AOS on loglevel */
    AOS_dump(loglevel);
    return EES_PL_SUCCESS;
}

/* Terminate function */
EES_PL_RC plugin_terminate(){
    EEF_log(LOG_INFO, "%s: plugin terminated\n", PLUGIN_NAME);
    return EES_PL_SUCCESS;
}

