/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

	\file		plugin_manager.h
	\brief 	API of the PluginManager
	\author	Aram Verstegen \& Mischa Sall\'e

	This header contains the declarations of the plugin manager functions:

  -# start_plugin_manager(void): start the plugin manager
  -# stop_plugin_manager(void): stop the plugin manager
  -# plugin_manager_start_threading(void): start threading in the plugin manager
  -# initialize_plugins(void): finds, loads and call plugin_initialize for all plugins
  -# run_plugins(char *policy_name[]): runs given policies, and call plugin_run for plugins
  -# term_plugins(void): terminates (calls plugin_terminate) for all plugins
  -# add_plugin_struct(char* argv[], const char*): add plugin to list of plugins
  -# get_plugin(const char*): get plugin for given name
  -# get_running_plugin(void): return currently executing plugin
  -# get_running_plugin_name(void): return name of currently running plugin


*/
#ifndef PLUGIN_MANAGER_H
#define PLUGIN_MANAGER_H

#include "eef/eef_return_codes.h"
#include "eef_plugindl_s.h"

/*
 * functions to handle the plugin manager itself
 */

/*! Start the plugin manager */
EES_RC start_plugin_manager(void);

/*! Stop the plugin manager */
EES_RC stop_plugin_manager(void);

/*! Start threading in the plugin manager */
void plugin_manager_start_threading(void);


/*
 * functions interacting with the plugins
 */

/*! Finds, loads and initializes (call plugin_initialize) for all plugins */
EES_RC initialize_plugins(void);

/*! Runs given policies, and runs plugins (call plugin_run) */ 
EES_RC run_plugins(char *policy_name[]);

/*! Terminates (calls plugin_terminate) for all plugins */
EES_RC term_plugins(void);

/*! Add plugin to list of plugins */
EES_RC add_plugin_struct(char* argv[], const char* name);


/*
 * convenience functions
 */

/*! Get plugin for given name */
eef_plugindl_t * get_plugin(const char*);

/*! Return currently executing plugin */
eef_plugindl_t * get_running_plugin(void);

/*! Return name of currently running plugin */
const char*      get_running_plugin_name(void);

#endif
