/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

	\file eef_plugindl_s.h
	\brief Defines the different types used for the plugins
	\author Aram Verstegen \& Mischa Sall\'e

*/

#ifndef EEF_PLUGINDL_S
#define EEF_PLUGINDL_S

/* limits.h for ARG_MAX */
#include <limits.h>
/* stdio.h for FILENAME_MAX */
#include <stdio.h>


typedef void *eef_proc_t;


/*! Identifiers for linked process symbols */
typedef enum eef_proctype_e {
    INITPROC,   /*!< corresponds to the plugin initialization function */
    RUNPROC,    /*!< corresponds to the plugin run function (get credentials) */
    TERMPROC,   /*!< corresponds to the plugin termination function */
    INTROPROC,  /*!< corresponds to the plugin introspect function */
    VERIFYPROC, /*!< corresponds to the plugin verification function */
    ENDOFPROCS  /*!< last enumeration value */
} eef_proctype_t;


/*!
 * \brief Node structure to hold plugin nodes
 */
typedef struct eef_plugindl_s
{
    void *                  handle;             /*!< dlopen handle to plugin module */
    eef_proc_t              procs[ENDOFPROCS];  /*!< list of handles to interface functions of plugin */
    char                    name[FILENAME_MAX]; /*!< name of plugin */
    int                     init_argc;          /*!< number of arguments for the initialization function */
    char *                  *init_argv;         /*!< list of arguments for the initialization function */
    struct eef_plugindl_s * next;               /*!< pointer to the next plugin in the plugin list */
} eef_plugindl_t;

#endif
