/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

	\file		eef_aos.h
	\brief	service API of the AOS (Attribute Object Store)
	\author	Aram Verstegen \& Mischa Sall\'e

*/

#ifndef EEF_AOS_SERVICE_H
#define EEF_AOS_SERVICE_H

#include <eef/eef_return_codes.h>


/************************************************************************
 * Function prototypes
 ************************************************************************/

/* Functions to handle the AOS itself: these should typically be called via the
 * EEF functions */

/*! Initializes the AOS */
EES_RC         /*@alt void@*/   AOS_Init (void);

/*! Cleans the thread-local AOS */
EES_RC         /*@alt void@*/   AOS_Clean(void);

/*! Terminates the AOS, cleans the global AOS */
EES_RC         /*@alt void@*/   AOS_Term (void);

/*! Sets the threading flag on for the AOS */
void				AOS_start_threading(void);

#endif

