/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

        \file           eics_http.h
        \brief  API of the HTTP EIC (EES Interface Component)
        \author Aram Verstegen \& Mischa Sall\'e

        This header contains the declarations of the HTTP EIC
        It contains the following core functions:
	-# start_xacml_http_server(void): Creates and starts xacml server
	-# stop_xacml_http_server(void): Stops xacml service once it's idle
	-# init_xacml_http_threading(void): Initializes the threading of the xacml server

	-# set_xacml_http_port(int): Sets the EES HTTP listening port in the EIC
	-# set_xacml_http_timeouts(int, int, int): Sets the EES HTTP timeouts in the EIC
	-# set_xacml_http_policy_names(char **): Sets the EES HTTP policies to use
*/

#ifndef EICS_HTTP_H
#define EICS_HTTP_H

#include "eef/eef_return_codes.h"

/* Lifecycle functions */

/*! Creates and starts xacml server (EES HTTP EIC).
 * Variables need to be set using set_xacml_http_* functions */
EES_RC start_xacml_http_server(void);

/*! Waits until xacml service is idle, then stops it. */
EES_RC stop_xacml_http_server(void);

/*! Initializes the threading of the xacml server */
void init_xacml_http_threading(void);


/* Configuring functions */

/*! Sets the EES HTTP listening port in the EIC */
EES_RC set_xacml_http_port(int port);

/*! Sets the EES HTTP timeouts in the EIC (for each value != -1) */
EES_RC set_xacml_http_timeouts(int send_timeout, int recv_timeout, int acpt_timeout);

/*! Sets the EES HTTP (NULL-terminated) policies to use. When NULL use all. */
void set_xacml_http_policy_names(char *policy_names[]);

#endif /* EICS_HTTP_H */
