/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

        \file           eics_common.h
        \brief  API of the EIC common functions (EES Interface Component)
        \author Aram Verstegen \& Mischa Sall\'e

        This header contains the declarations of the EIC 'library'
        It contains the following core functions:
        -# extractRequestSubjectToAOS(const xacml_request_t): extract subject from request and store in AOS
        -# extractRequestActionToAOS(const xacml_request_t): extract action from request and store in AOS
        -# extractRequestResourceToAOS(const xacml_request_t): extract resource from request and store in AOS
	-# extractRequestEnvironmentToAOS(const xacml_request_t): extract environment from request and store in AOS

        -# constructResponse(xacml_response_t *): construct response from current thread-local AOS
        -# constructFailureResponse(xacml_response_t *): construct failure response using current thread-local AOS
        -# eef_xacml_authorize(const xacml_request_t,xacml_response_t,char**,const char *): Convenience function that does the extraction, EEF run and response construction
*/

#ifndef EES_EICS_H
#define EES_EICS_H

#include <xacml_datatypes.h>

/**
 * Functions to extract attributes from xacml_request_t and store in the AOS
 */
int extractRequestSubjectToAOS     (const xacml_request_t request);
int extractRequestActionToAOS      (const xacml_request_t request);
int extractRequestResourceToAOS    (const xacml_request_t request);
int extractRequestEnvironmentToAOS (const xacml_request_t request);

/**
 * Functions to get attributes from the AOS and produce an xacml_response_t
 */
int constructResponse(xacml_response_t *       response);
int constructFailureResponse(xacml_response_t *response);

/**
 * Convenience function that:
 * 1) parses the request and stores the input in the AOS (extractRequest...)
 * 2) runs the EEF for the given NULL-terminated policy_names (or NULL for all)
 * 3) constructs the response from the AOS after the EEF run (constructResponse)
 */
int eef_xacml_authorize(const xacml_request_t request,
                        xacml_response_t      response,
			char *policy_names[],
			const char *issuer);

#endif /* EES_EICS_H */

