/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

	\file eef_return_codes.h
	\brief API of the EEF return codes
	\author Aram Verstegen \& Mischa Sall\'e

*/
#ifndef EEF_RETURN_CODES_H
#define EEF_RETURN_CODES_H

/*! Return codes to be used in the EEF library. */
typedef enum {
  EES_FAILURE = -1, /*! Failure */
  EES_SUCCESS =  0  /*! Success */
} EES_RC;

/*! Return codes to be used in EEF plugins. */
typedef enum {
  EES_PL_FAILURE = -1, /*! Failure */
  EES_PL_SUCCESS =  0  /*! Success */
} EES_PL_RC;

#endif
