/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

	\file		eef_plugin_typedefs.h
	\brief	API for EEF plugins, defining function prototypes
	\author	Aram Verstegen \& Mischa Sall\'e

	This header contains the prototype definitions of the functions that
	should be provided by all plugins. See further eef_plugin.h

*/
#ifndef EEF_PLUGIN_TYPEDEFS_H
#define EEF_PLUGIN_TYPEDEFS_H

#include <eef/eef_return_codes.h>

/*!< plugin initialization function, AOS is global and read/writable */
typedef EES_PL_RC plugin_init_t(int argc, char* argv[]);

/*!< plugin run function, global AOS is read-only */
typedef EES_PL_RC plugin_run_t(void);	    

/*!< plugin termination function, to cleanup memory */
typedef EES_PL_RC plugin_term_t(void);

#endif /* EEF_PLUGIN_TYPEDEFS_H */
