/**
 * Copyright 2010-2013  Members of the EMI Collaboration.
 * Copyright 2010-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*!

	\file		eef_plugin.h
	\brief	API for EEF plugins
	\author	Aram Verstegen \& Mischa Sall\'e

	This header contains the declarations of functions that should be
	provided by all plugins plus a few functions which are provided by the
	EEF framework.
	It contains the following core functions:
	-# plugin_initialize(argc, argv): initializes plugin
	-# plugin_run(): runs plugin
	-# plugin_terminate(): terminates plugin
	Plus the following functions declared in eef_library.h
	-# EEF_getRunningPluginName(void): Returns the name of the currently running plugin
        -# EEF_getMajorVersion(void): Return EEF major version
        -# EEF_getMinorVersion(void): Return EEF minor version
        -# EEF_getPatchVersion(void): Return EEF patch version
*/
#ifndef PLUGIN_H
#define PLUGIN_H

#include <eef/eef_plugin_typedefs.h>

/* plugins should implement the following three */

/* Called in the initialization phase,
 * AOS is still global and read/write */
plugin_init_t plugin_initialize;

/* Called in the run phase,
 * thread-local is read/write, global AOS is read-only */
plugin_run_t plugin_run;

/* Called in the termination phase, to clean-up memory */
plugin_term_t plugin_terminate;

/* Note: The next functions are also declared in eef_library.h */
const char* EEF_getRunningPluginName(void); /* name of running plugin */
unsigned int EEF_getMajorVersion(void);	    /* EEF major version */
unsigned int EEF_getMinorVersion(void);	    /* EEF minor version */
unsigned int EEF_getPatchVersion(void);	    /* EEF patch version */

#endif
