/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.glite.security.delegation.GrDPX509Util;

public class GrDProxyDlgeeOptions {
    private String dlgeeDN = null;
    private String dlgeePass = null;
    private String delegationStorage = null;
    private String dlgeeStorageFactory = null;
    private String dlgeeStorageDbPool = null;
    private String proxyFile = null;
    private int dlgeeKeySize = -1;
    private boolean requireVomsAttributes = true;
    private String vomsDir = null;
    private String vomsCAs = null;
    private String revocationChecking = null;
    private String namespace = null;
    private String updateInterval = null;
    private boolean limited = false;

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public GrDProxyDlgeeOptions(String filename) throws IOException {
        InputStream st = null;
        try {
            st = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (st == null) {
            st = GrDProxyDlgeeOptions.class.getClassLoader().getResourceAsStream(filename);
        }
        Properties props = new Properties();
        props.load(st);
        this.init(props);
    }

    public GrDProxyDlgeeOptions(Properties props) {
        this.init(props);
    }

    public GrDProxyDlgeeOptions() {
    }

    public void init(Properties props) {
        this.dlgeeDN = props.getProperty("dlgeeDN");
        this.dlgeePass = props.getProperty("dlgeePass");
        this.proxyFile = props.getProperty("proxyFile");
        this.delegationStorage = props.getProperty("delegationStorage");
        this.dlgeeStorageFactory = props.getProperty("dlgeeStorageFactory");
        this.dlgeeStorageDbPool = props.getProperty("dlgeeStorageDbPool");
        this.dlgeeKeySize = Integer.parseInt(props.getProperty("dlgeeKeySize"));
        String reqString = props.getProperty("requireVomsAttributes");
        if (reqString != null) {
            this.requireVomsAttributes = Boolean.parseBoolean(reqString);
        }
        this.vomsDir = props.getProperty("vomsDir");
        this.vomsCAs = props.getProperty("vomsCAs");
        this.revocationChecking = props.getProperty("revocationChecking");
        this.namespace = props.getProperty("namespace");
        this.updateInterval = props.getProperty("updateInterval");
        String limitedString = props.getProperty("limitedProxy");
        if (limitedString != null) {
            this.limited = Boolean.parseBoolean(limitedString);
        }
    }

    public String getDlgeeDN() {
        return this.dlgeeDN;
    }

    public String getDlgeePass() {
        return this.dlgeePass;
    }

    public String getDlgeeProxyFile() {
        if (this.proxyFile == null) {
            return GrDPX509Util.getDefaultProxyFile();
        }
        return this.proxyFile;
    }

    public String getDlgeeStorage() {
        if (this.delegationStorage == null) {
            return "\tmp";
        }
        return this.delegationStorage;
    }

    public String getDlgeeStorageFactory() {
        return this.dlgeeStorageFactory;
    }

    public String getDlgeeStorageDbPool() {
        return this.dlgeeStorageDbPool;
    }

    public int getDlgeeKeySize() {
        return this.dlgeeKeySize;
    }

    public boolean isRequireVomsAttributes() {
        return this.requireVomsAttributes;
    }

    public void setDlgeeDN(String dn) {
        this.dlgeeDN = dn;
    }

    public void setDlgeePass(String dgp) {
        this.dlgeePass = dgp;
    }

    public void setDlgeeProxyFile(String pf) {
        this.proxyFile = pf;
    }

    public void setDlgeeStorage(String stg) {
        this.delegationStorage = stg;
    }

    public void setDlgeeStorageFactory(String stgType) {
        this.dlgeeStorageFactory = stgType;
    }

    public void setDlgeeStorageDbPool(String stgDbPool) {
        this.dlgeeStorageDbPool = stgDbPool;
    }

    public void setDlgeeKeySize(int keySize) {
        this.dlgeeKeySize = keySize;
    }

    public void setRequireVomsAttributes(boolean required) {
        this.requireVomsAttributes = required;
    }

    public String getVomsDir() {
        return this.vomsDir;
    }

    public void setVomsDir(String vomsDir) {
        this.vomsDir = vomsDir;
    }

    public String getVomsCAs() {
        return this.vomsCAs;
    }

    public void setVomsCAs(String vomsCAs) {
        this.vomsCAs = vomsCAs;
    }

    public String getRevocationChecking() {
        return this.revocationChecking;
    }

    public void setRevocationChecking(String revocationChecking) {
        this.revocationChecking = revocationChecking;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(String updateInterval) {
        this.updateInterval = updateInterval;
    }
}

