/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.Hex;
import org.glite.security.delegation.storage.GrDPStorageFactory;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;

public class GrDPX509Util {
    private static final Logger LOGGER = Logger.getLogger(GrDPX509Util.class);
    public static final String CERT_CHAIN_CONTENT_TYPE = "application/x-x509-user-cert-chain";
    public static final String CERT_REQ_CONTENT_TYPE = "application/x-x509-cert-request";
    private static MessageDigest s_digester = null;
    private static VOMSACValidator vomsValidator = null;
    public static boolean windows = System.getProperty("os.name").startsWith("Windows");

    public static synchronized byte[] digest(byte[] input) {
        return s_digester.digest(input);
    }

    public static boolean changeFileMode(String file, int mode) {
        if (windows) {
            return true;
        }
        Runtime runtime = Runtime.getRuntime();
        String[] cmd = new String[]{"chmod", String.valueOf(mode), file};
        try {
            Process process = runtime.exec(cmd, null);
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDefaultCertFile() {
        String location = null;
        location = System.getProperty("X509_USER_CERT");
        return location;
    }

    public static String getDefaultKeyFile() {
        String location = null;
        location = System.getProperty("X509_USER_KEY");
        return location;
    }

    public static String getDefaultCertLocation() {
        String location = null;
        location = System.getProperty("X509_CERT_DIR");
        return location;
    }

    public static String getDefaultProxyFile() {
        String location = System.getProperty("X509_USER_PROXY");
        return location;
    }

    public static String digestFileName(String delegationid_in, String DN_in) {
        byte[] dgstDlgID = null;
        byte[] dgstDN = null;
        String filenameP1 = null;
        String filenameP2 = "-";
        String filenameP3 = null;
        dgstDlgID = GrDPX509Util.digest(delegationid_in.getBytes());
        dgstDlgID = GrDPX509Util.get8MostSignificant(dgstDlgID);
        filenameP1 = new String(Hex.encode((byte[])dgstDlgID));
        LOGGER.debug((Object)("DN TO DIGEST : " + DN_in.replaceAll("CN=proxy,", "")));
        dgstDN = GrDPX509Util.digest(DN_in.replaceAll("CN=proxy,", "").getBytes());
        dgstDN = GrDPX509Util.get8MostSignificant(dgstDN);
        filenameP3 = new String(Hex.encode((byte[])dgstDN));
        LOGGER.debug((Object)("Digest of file name : " + filenameP1 + filenameP2 + filenameP3));
        return filenameP1 + filenameP2 + filenameP3;
    }

    private static byte[] get8MostSignificant(byte[] input) {
        byte[] result = new byte[8];
        for (int i = 0; i <= 7; ++i) {
            result[i] = input[i];
        }
        return result;
    }

    private static byte[] getMostSignificant(byte[] input, int n) {
        byte[] result = new byte[n];
        for (int i = 0; i <= n - 1; ++i) {
            result[i] = input[i];
        }
        return result;
    }

    public static String certReqResponse(String certReq) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1 200 ok\r\n");
        buffer.append("Content-type: application/x-x509-cert-request\r\n\r\n");
        buffer.append(certReq);
        return buffer.toString();
    }

    public static String certProxyResponse(String proxyCert) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1 200 ok\r\n");
        buffer.append("Content-type: application/x-x509-user-cert-chain\r\n\r\n");
        buffer.append(proxyCert);
        return buffer.toString();
    }

    public static String errorResponse(String errorMsg) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HTTP/1.1 " + errorMsg + "\r\n");
        buffer.append("\r\n");
        return buffer.toString();
    }

    public static String getDlgeePropertyFile() {
        String dlgeePropertyFile = null;
        dlgeePropertyFile = System.getProperty("GLITE_DLGEE_PROPERTY", "dlgee.properties");
        LOGGER.debug((Object)("GLITE_DLGEE_PROPERTY : " + dlgeePropertyFile));
        return dlgeePropertyFile;
    }

    public static String getDlgorPropertyFile() {
        String dlgorPropertyFile = null;
        dlgorPropertyFile = System.getProperty("GLITE_DLGOR_PROPERTY", "dlgor.properties");
        return dlgorPropertyFile;
    }

    public static GrDPStorageFactory getGrDPStorageFactory(String factoryClass) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        LOGGER.debug((Object)"Entered getGrDStorage.");
        Class<?> storageClass = Class.forName(factoryClass);
        LOGGER.debug((Object)("Successfully loaded class '" + factoryClass + "'"));
        return (GrDPStorageFactory)storageClass.newInstance();
    }

    public static String createCertificateRequest(X509Certificate subjectCert, String sigAlgName, KeyPair keyPair) throws GeneralSecurityException {
        PKCS10CertificationRequest certRequest = new PKCS10CertificationRequest(sigAlgName, subjectCert.getSubjectX500Principal(), keyPair.getPublic(), null, keyPair.getPrivate());
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter);
        try {
            pemWriter.writeObject((Object)certRequest);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Certificate output as string failed: " + e.getMessage());
        }
        finally {
            try {
                pemWriter.close();
            }
            catch (IOException e) {}
        }
        return stringWriter.toString();
    }

    public static KeyPair getKeyPair(int size) {
        SecureRandom rand = new SecureRandom();
        JDKKeyPairGenerator.RSA keyPairGen = new JDKKeyPairGenerator.RSA();
        keyPairGen.initialize(size, rand);
        return keyPairGen.generateKeyPair();
    }

    public static String generateSessionID(PublicKey pk) {
        return new String(Hex.encode((byte[])GrDPX509Util.getMostSignificant(GrDPX509Util.digest(pk.getEncoded()), 20)));
    }

    public static String genDlgID(String dn, String[] vomsAttributes) {
        String originalString = dn;
        if (vomsAttributes != null) {
            for (int i = 0; i < vomsAttributes.length; ++i) {
                originalString = originalString + vomsAttributes[i];
            }
        } else {
            LOGGER.debug((Object)"No VOMS attributes in client certificate. Generating DLG ID usingonly the client DN.");
        }
        byte[] origStringB = originalString.getBytes();
        byte[] digest = GrDPX509Util.digest(origStringB);
        byte[] mostSigni = GrDPX509Util.getMostSignificant(digest, 20);
        byte[] hexEnc = Hex.encode((byte[])mostSigni);
        String digestString = new String(hexEnc);
        LOGGER.debug((Object)("Digest VOMS Attributes: " + digestString));
        return digestString;
    }

    public static String[] getVOMSAttributes(X509Certificate[] certs) {
        if (vomsValidator == null) {
            vomsValidator = VOMSValidators.newValidator();
        }
        List attributeCerts = vomsValidator.validate(certs);
        ArrayList attributes = new ArrayList();
        for (VOMSAttribute attributeCert : attributeCerts) {
            List theseAttributes;
            if (attributeCert == null || (theseAttributes = attributeCert.getFQANs()) == null) continue;
            attributes.addAll(theseAttributes);
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    public static String toStringVOMSAttrs(String[] vomsAttributes) {
        if (vomsAttributes == null) {
            return "";
        }
        String vomsAttrsStr = "";
        for (int i = 0; i < vomsAttributes.length; ++i) {
            vomsAttrsStr = vomsAttrsStr + "\t" + vomsAttributes[i];
        }
        return vomsAttrsStr;
    }

    public static String[] fromStringVOMSAttrs(String vomsAttributesStr) {
        if (vomsAttributesStr == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer("\t");
        ArrayList<String> vomsAttributes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            vomsAttributes.add(st.nextToken());
        }
        return vomsAttributes.toArray(new String[0]);
    }

    static {
        try {
            s_digester = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("Message digester implementation not found: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("Delegation utilities code initialization failed: " + e.getMessage(), e);
        }
    }
}

