/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.glite.security.delegation.DelegationException;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.error.VOMSValidationErrorMessage;

public class CertInfoTriple {
    private static final Logger LOGGER = Logger.getLogger(CertInfoTriple.class);
    public X509Certificate endEntityCert = null;
    public String dn = null;
    public String[] vomsAttributes = null;

    public CertInfoTriple(X509Certificate[] certs, VOMSACValidator validator, boolean requireVomsAttrs) throws DelegationException {
        if (certs == null) {
            throw new DelegationException("No certificates given.");
        }
        this.endEntityCert = ProxyUtils.getEndUserCertificate((X509Certificate[])certs);
        if (this.endEntityCert == null) {
            throw new DelegationException("No end entity certificate found on the certificate chain.");
        }
        this.dn = X500NameUtils.getReadableForm((X500Principal)this.endEntityCert.getSubjectX500Principal());
        if (this.dn == null) {
            throw new DelegationException("Failed to get client DN.");
        }
        if (validator != null) {
            try {
                this.vomsAttributes = this.getVomsAttributes(certs, validator);
            }
            catch (Exception e) {
                if (requireVomsAttrs) {
                    throw new DelegationException("Failed to get required VOMS attributes " + e.getClass() + " " + e.getMessage(), e);
                }
                LOGGER.warn((Object)("VOMS attribute retrieval failed, but they are not required, so continuing. Error was: " + e.getClass() + " " + e.getMessage()), (Throwable)e);
            }
        }
        if (requireVomsAttrs) {
            if (this.vomsAttributes == null || this.vomsAttributes.length == 0) {
                throw new DelegationException("Failed to get required VOMS attributes.");
            }
            for (String attribute : this.vomsAttributes) {
                if (attribute != null && attribute.length() != 0) continue;
                throw new DelegationException("Invalid empty VOMS attribute found.");
            }
        }
    }

    public String[] getVomsAttributes(X509Certificate[] certs, VOMSACValidator validator) throws DelegationException {
        List results = validator.validateWithResult(certs);
        ArrayList<String> attributeList = new ArrayList<String>();
        for (VOMSValidationResult r : results) {
            if (r.isValid()) {
                VOMSAttribute attrs = r.getAttributes();
                for (String attribute : attrs.getFQANs()) {
                    attributeList.add(attribute);
                }
                continue;
            }
            String error = "";
            for (VOMSValidationErrorMessage errorMessage : r.getValidationErrors()) {
                error = error + ", " + errorMessage;
            }
            throw new DelegationException("Error(s) while getting VOMS attributes: " + error);
        }
        return attributeList.toArray(new String[attributeList.size()]);
    }
}

