/*
 * Decompiled with CFR 0.152.
 */
package terapathsexamplejavaclient;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import terapathsexamplejavaclient.Bandwidth;
import terapathsexamplejavaclient.Bandwidths;
import terapathsexamplejavaclient.ReservationData;
import terapathsexamplejavaclient.ScheduleSlots;
import terapathsexamplejavaclient.TpsAPISEI;
import terapathsexamplejavaclient.TpsAPI_Impl;
import terapathsexamplejavaclient.Who;

public class Main {
    private static TpsAPISEI tpsAPISEIPort = null;
    private static BufferedReader readBuffer = null;
    private static String propfile = "";
    private static String tpsAPI_ServerURL = "";
    private static String tpsAPI_userName = "";
    private static String tpsAPI_passWord = "";
    private static String default_srcIP = "";
    private static String default_dstIP = "";
    private static int default_srcLoPort = 0;
    private static int default_srcHiPort = 0;
    private static int default_dstLoPort = 0;
    private static int default_dstHiPort = 0;
    private static String default_direction = "";
    private static String default_protocol = "";
    private static long default_duration = 0L;
    private static String default_class = "";

    public static void main(String[] args) {
        String operation = null;
        readBuffer = new BufferedReader(new InputStreamReader(System.in));
        String propfile = System.getProperty("user.dir") + System.getProperty("file.separator") + "terapathsClient.properties";
        System.out.println("\nTeraPaths API example client\n\nClient properties file: " + propfile);
        String keyStoreDir = System.getProperty("user.dir") + System.getProperty("file.separator");
        System.out.println("keyStore/trustStore directory:" + keyStoreDir);
        try {
            System.setProperty("javax.net.ssl.keyStoreType", "JKS");
            System.setProperty("javax.net.ssl.keyStore", keyStoreDir + "terapathsClientKeystore.jks");
            System.setProperty("javax.net.ssl.keyStorePassword", "password");
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
            System.setProperty("javax.net.ssl.trustStore", keyStoreDir + "terapathsClientTruststore.jks");
            System.setProperty("javax.net.ssl.trustStorePassword", "password2");
        }
        catch (Exception e) {
            System.out.println("Failed to set SSL properties...");
            e.printStackTrace();
        }
        try {
            FileInputStream fstream = new FileInputStream(propfile);
            Properties props = new Properties();
            props.load(fstream);
            tpsAPI_ServerURL = props.getProperty("API.URL", "http://198.124.220.9:8080/terapathsAPI/tpsAPI");
            tpsAPI_userName = props.getProperty("API.username");
            tpsAPI_passWord = props.getProperty("API.password");
            default_srcIP = props.getProperty("default.srcIP", "198.124.220.134");
            default_dstIP = props.getProperty("default.dstIP", "192.84.86.28");
            default_srcLoPort = Integer.parseInt(props.getProperty("default.srcLoPort", "10000"));
            default_srcHiPort = Integer.parseInt(props.getProperty("default.srcHiPort", "10000"));
            default_dstLoPort = Integer.parseInt(props.getProperty("default.dstLoPort", "10000"));
            default_dstHiPort = Integer.parseInt(props.getProperty("default.dstHiPort", "10000"));
            default_direction = props.getProperty("default.direction", "unidirectional");
            default_protocol = props.getProperty("default.protocol", "tcp");
            default_duration = Integer.parseInt(props.getProperty("default.duration", "180"));
            default_class = props.getProperty("default.class", "EF");
        }
        catch (Exception e) {
            System.out.println("Caught exception " + e);
            e.printStackTrace();
        }
        try {
            tpsAPI_ServerURL = Main.inputParameter(readBuffer, "\nSelect TeraPaths API URL", tpsAPI_ServerURL);
        }
        catch (IOException ex) {
            System.out.println("Caught IO exception " + ex);
            ex.printStackTrace();
        }
        System.out.println("\nAPI URL set to <" + tpsAPI_ServerURL + ">");
        System.out.println("\nUser <" + tpsAPI_userName + ">");
        try {
            TpsAPI_Impl tpsAPI = new TpsAPI_Impl();
            tpsAPISEIPort = tpsAPI.getTpsAPISEIPort();
            ((Stub)tpsAPISEIPort)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)tpsAPI_ServerURL);
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            operation = Main.inputParameter(readBuffer, "\nTeraPaths API methods:\n\n(gb) get bandwidths\n(gp) get path\n(gs) get schedule\n(rv) reserve\n(cm) commit\n(rc) reserve and commit\n(cn) cancel\n\n(qt) quit client\n\nSelection", "qt");
            while (!operation.equals("qt")) {
                if (operation.equals("gb")) {
                    System.out.println("\nInvoking getBandwidths...");
                    Main.getBandwidths();
                } else if (operation.equals("gp")) {
                    System.out.println("\nInvoking getPath...");
                    Main.getPath();
                } else if (operation.equals("gs")) {
                    System.out.println("\nInvoking getSchedule...");
                    Main.getSchedule();
                } else if (operation.equals("rv")) {
                    System.out.println("\nInvoking reserve...");
                    Main.reserve();
                } else if (operation.equals("cm")) {
                    System.out.println("\nInvoking commit...");
                    Main.commit(null);
                } else if (operation.equals("rc")) {
                    System.out.println("\nInvoking reserve, then commit...");
                    Main.reserveAndCommit();
                } else if (operation.equals("cn")) {
                    System.out.println("\nInvoking cancel...");
                    Main.cancel();
                } else {
                    System.out.println("\nNo such method!");
                }
                operation = Main.inputParameter(readBuffer, "\nTeraPaths API methods:\n\n(gb) get bandwidths\n(gp) get path\n(gs) get schedule\n(rv) reserve\n(cm) commit\n(rc) reserve and commit\n(cn) cancel\n\n(qt) quit client\n\nSelection", "qt");
            }
        }
        catch (IOException ex) {
            System.out.println("Caught IOException " + ex);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("Caught Exception " + ex);
            ex.printStackTrace();
        }
    }

    public static String inputParameter(BufferedReader readBuffer, String prompt, String defaultValue) throws IOException {
        String inputString = null;
        System.out.print(prompt + ": [" + defaultValue.trim() + "] :");
        System.out.flush();
        inputString = readBuffer.readLine().trim();
        if (inputString == null || inputString.equals("")) {
            inputString = defaultValue.trim();
        }
        return inputString;
    }

    public static void getPath() {
        String[] path = null;
        String srcIP = "";
        String dstIP = "";
        try {
            srcIP = Main.inputParameter(readBuffer, "Source IP address", default_srcIP);
            dstIP = Main.inputParameter(readBuffer, "Destination IP address", default_dstIP);
        }
        catch (IOException ex) {
            System.out.println("Caught IO exception " + ex);
            ex.printStackTrace();
        }
        try {
            path = tpsAPISEIPort.tpsAPI_getPath(tpsAPI_userName, tpsAPI_passWord, srcIP, dstIP);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (path != null) {
            for (int i = 0; i < path.length; ++i) {
                System.out.println("path[" + i + "]=" + path[i]);
            }
        } else {
            System.out.println("ERROR: path array is null...");
        }
    }

    public static void getBandwidths() {
        Bandwidths[] bws = null;
        String srcIP = "";
        String dstIP = "";
        try {
            srcIP = Main.inputParameter(readBuffer, "Source IP address", default_srcIP);
            dstIP = Main.inputParameter(readBuffer, "Destination IP address", default_dstIP);
        }
        catch (IOException ex) {
            System.out.println("Caught IO exception " + ex);
            ex.printStackTrace();
        }
        try {
            bws = tpsAPISEIPort.tpsAPI_getBandwidths(tpsAPI_userName, tpsAPI_passWord, srcIP, dstIP);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (bws != null) {
            for (int i = 0; i < bws.length; ++i) {
                if (bws[i] == null) continue;
                System.out.println("Bandwidth classes for site [" + i + "]");
                for (int j = 0; j < bws[i].getBw().length; ++j) {
                    System.out.println("Bandwidth class [" + j + "]: <" + bws[i].getBw()[j].getClassName() + ">, " + bws[i].getBw()[j].getBandwidth() + "Mbps");
                }
            }
        } else {
            System.out.println("ERROR: bandwidths array is null...");
        }
    }

    public static void getSchedule() {
        ScheduleSlots[] ss = null;
        Bandwidth bw = new Bandwidth();
        String srcIP = "";
        String dstIP = "";
        String direction = "";
        String bwc = null;
        long start = Long.MIN_VALUE;
        long end = Long.MAX_VALUE;
        try {
            srcIP = Main.inputParameter(readBuffer, "Source IP address", default_srcIP);
            dstIP = Main.inputParameter(readBuffer, "Destination IP address", default_dstIP);
            direction = Main.inputParameter(readBuffer, "Flow type (uni/bidirectional)", default_direction);
            bwc = Main.inputParameter(readBuffer, "Bandwidth class", default_class);
        }
        catch (IOException ex) {
            System.out.println("Caught IO exception " + ex);
            ex.printStackTrace();
        }
        bw.setClassName(bwc.trim());
        try {
            ss = tpsAPISEIPort.tpsAPI_getSchedule(tpsAPI_userName, tpsAPI_passWord, direction, srcIP, dstIP, start, end, bw);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i] == null) continue;
                System.out.println("Class " + bw.getClassName() + " schedule for site [" + i + "]");
                for (int j = 0; j < ss[i].getSs().length; ++j) {
                    System.out.println("Schedule slot[" + j + "]: <" + ss[i].getSs()[j].getStartTime() + ">, <" + ss[i].getSs()[j].getStopTime() + ">");
                }
            }
        } else {
            System.out.println("Schedule for class " + bw.getClassName() + " is null...");
        }
    }

    public static ReservationData reserve() {
        ReservationData rdSnd = new ReservationData();
        ReservationData rdRcv = null;
        Who who = new Who();
        Bandwidth bw = new Bandwidth();
        String srcIP = "";
        int srcLoPort = 0;
        int srcHiPort = 0;
        String dstIP = "";
        int dstLoPort = 0;
        int dstHiPort = 0;
        String direction = "";
        String protocol = "";
        String bwc = null;
        long start = 0L;
        long duration = 0L;
        try {
            srcIP = Main.inputParameter(readBuffer, "Source IP address", default_srcIP);
            srcLoPort = Integer.parseInt(Main.inputParameter(readBuffer, "Source port number range start", Integer.toString(default_srcLoPort)));
            srcHiPort = Integer.parseInt(Main.inputParameter(readBuffer, "Source port number range end", Integer.toString(default_srcHiPort)));
            dstIP = Main.inputParameter(readBuffer, "Destination IP address", default_dstIP);
            dstLoPort = Integer.parseInt(Main.inputParameter(readBuffer, "Destination port number range start", Integer.toString(default_dstLoPort)));
            dstHiPort = Integer.parseInt(Main.inputParameter(readBuffer, "Destination port number range end", Integer.toString(default_dstHiPort)));
            direction = Main.inputParameter(readBuffer, "Flow type (uni/bidirectional)", default_direction);
            protocol = Main.inputParameter(readBuffer, "Protocol", default_protocol);
            bwc = Main.inputParameter(readBuffer, "Bandwidth class", default_class);
            start = Long.parseLong(Main.inputParameter(readBuffer, "Reservation start time (ms)", Long.toString(System.currentTimeMillis() + 120000L)));
            duration = Long.parseLong(Main.inputParameter(readBuffer, "Reservation duration (s)", Long.toString(default_duration)));
        }
        catch (IOException ex) {
            System.out.println("Caught IO exception " + ex);
            ex.printStackTrace();
        }
        bw.setClassName(bwc.trim());
        who.setName(tpsAPI_passWord);
        rdSnd.setUserName(tpsAPI_userName);
        rdSnd.setWho(who);
        rdSnd.setSrcIp(srcIP);
        rdSnd.setSrcPortMin(srcLoPort);
        rdSnd.setSrcPortMax(srcHiPort);
        rdSnd.setDestIp(dstIP);
        rdSnd.setDestPortMin(dstLoPort);
        rdSnd.setDestPortMax(dstHiPort);
        rdSnd.setBandwidth(bw);
        rdSnd.setDirection(direction);
        rdSnd.setProtocol(protocol);
        rdSnd.setStartTime(start);
        rdSnd.setDuration(duration);
        try {
            rdRcv = tpsAPISEIPort.tpsAPI_reserve(rdSnd);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (rdRcv != null) {
            Main.printRD(rdRcv, ">>>");
        } else {
            System.out.println("ERROR: null ReservationData...");
        }
        return rdRcv;
    }

    public static void printRD(ReservationData rd, String marker) {
        String dump = "{" + marker + "}\nReservationData content dump - begin.";
        if (rd == null) {
            dump = "null ReservationData";
        } else {
            dump = rd.who != null ? dump + "\nwho = " + rd.who.getName() : dump + "\nwho = null";
            dump = dump + "\nuserName = " + rd.getUserName();
            dump = dump + "\nprotocol = " + rd.getProtocol();
            dump = dump + "\ndirection = " + rd.getDirection();
            dump = dump + "\nsrcIp = " + rd.getSrcIp() + "\nsrcPortMin = " + rd.getSrcPortMin() + "\nsrcPortMax = " + rd.getSrcPortMax();
            dump = dump + "\ndestIp = " + rd.getDestIp() + "\ndestPortMin = " + rd.getDestPortMin() + "\ndestPortMax = " + rd.getDestPortMax();
            if (rd.getBandwidth() != null) {
                dump = dump + "\nbandwidth = " + rd.getBandwidth().getBandwidth();
                dump = dump + "\nclassName = " + rd.getBandwidth().getClassName();
            } else {
                dump = dump + "\nbandwidth = null";
            }
            dump = dump + "\nstartTime = " + rd.getStartTime() + "\ndTMinus = " + rd.getDTMinus() + "\ndTPlus = " + rd.getDTPlus();
            dump = dump + "\nstartTimeMin = " + rd.getStartTimeMin() + "\nstartTimeMax = " + rd.getStartTimeMax();
            dump = dump + "\nduration = " + rd.getDuration() + "\nid = " + rd.getId() + "\nsrcName = " + rd.getSrcName() + "\ndestName = " + rd.getDestName();
            dump = dump + "\ntimeout = " + rd.getTimeout() + "\nstatus = " + rd.getStatus();
            dump = dump + "\nrelatedReservationIds = " + rd.getRelatedReservationIds();
        }
        System.out.println(dump + "\n{" + marker + "}\nReservationData content dump - end.");
    }

    public static void commit(ReservationData rd) {
        boolean cflag = false;
        ReservationData rdSubmit = null;
        Who who = new Who();
        String srcIP = "";
        String dstIP = "";
        String rid = "";
        String rrids = "";
        if (rd == null) {
            rdSubmit = new ReservationData();
            try {
                rid = Main.inputParameter(readBuffer, "Reservation id", "");
                rrids = Main.inputParameter(readBuffer, "Related reservation ids", "");
                srcIP = Main.inputParameter(readBuffer, "Source IP address", default_srcIP);
                dstIP = Main.inputParameter(readBuffer, "Destination IP address", default_dstIP);
            }
            catch (IOException ex) {
                System.out.println("Caught IO exception " + ex);
                ex.printStackTrace();
            }
            who.setName(tpsAPI_passWord);
            rdSubmit.setUserName(tpsAPI_userName);
            rdSubmit.setWho(who);
            rdSubmit.setSrcIp(srcIP);
            rdSubmit.setDestIp(dstIP);
            rdSubmit.setId(rid);
            rdSubmit.setRelatedReservationIds(rrids);
        } else {
            rdSubmit = rd;
        }
        try {
            cflag = tpsAPISEIPort.tpsAPI_commit(rdSubmit);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cflag) {
            System.out.println("Reservation " + rdSubmit.getId() + " was committed successfully.");
        } else {
            System.out.println("Failed to commit reservation " + rdSubmit.getId() + ".");
        }
    }

    public static void reserveAndCommit() {
        ReservationData rdXfer = null;
        rdXfer = Main.reserve();
        if (rdXfer != null) {
            Main.commit(rdXfer);
        } else {
            System.out.println("Failed to reserve, cannot commit.");
        }
    }

    public static void cancel() {
        boolean cflag = false;
        ReservationData rdSubmit = new ReservationData();
        Who who = new Who();
        String rid = "";
        try {
            rid = Main.inputParameter(readBuffer, "Reservation id", "");
        }
        catch (IOException ex) {
            System.out.println("Caught IO exception " + ex);
            ex.printStackTrace();
        }
        who.setName(tpsAPI_passWord);
        rdSubmit.setUserName(tpsAPI_userName);
        rdSubmit.setWho(who);
        rdSubmit.setId(rid);
        try {
            cflag = tpsAPISEIPort.tpsAPI_cancel(rdSubmit);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cflag) {
            System.out.println("Reservation " + rdSubmit.getId() + " was cancelled successfully.");
        } else {
            System.out.println("Failed to cancel reservation " + rdSubmit.getId() + ".");
        }
    }
}

