/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import java.io.InputStream;
import org.globus.common.ChainedIOException;
import org.globus.ftp.FTPClient;
import org.globus.ftp.InputStreamDataSink;
import org.globus.ftp.exception.FTPException;
import org.globus.ftp.vanilla.TransferState;
import org.globus.io.streams.GlobusInputStream;

public class FTPInputStream
extends GlobusInputStream {
    protected InputStream input;
    protected FTPClient ftp;
    protected TransferState state;
    protected boolean useGFD47;

    protected FTPInputStream() {
    }

    public FTPInputStream(String host, int port, String user, String pwd, String file) throws IOException, FTPException {
        this(host, port, user, pwd, file, true, 1);
    }

    public FTPInputStream(String host, int port, String user, String pwd, String file, boolean passive, int type) throws IOException, FTPException {
        this(host, port, user, pwd, file, passive, type, true);
    }

    public FTPInputStream(String host, int port, String user, String pwd, String file, boolean passive, int type, boolean useGFD47) throws IOException, FTPException {
        this.ftp = new FTPClient(host, port);
        this.ftp.authorize(user, pwd);
        this.useGFD47 = useGFD47 && this.ftp.isFeatureSupported("GETPUT");
        this.get(passive, type, file);
    }

    protected void get(boolean passive, int type, String remoteFile) throws IOException, FTPException {
        InputStreamDataSink sink = null;
        try {
            this.ftp.setType(type);
            sink = new InputStreamDataSink();
            this.input = sink.getInputStream();
            if (this.useGFD47) {
                this.state = this.ftp.asynchGet2(remoteFile, passive, sink, null);
            } else {
                if (passive) {
                    this.ftp.setPassive();
                    this.ftp.setLocalActive();
                } else {
                    this.ftp.setLocalPassive();
                    this.ftp.setActive();
                }
                this.state = this.ftp.asynchGet(remoteFile, sink, null);
            }
            this.state.waitForStart();
        }
        catch (FTPException e) {
            if (sink != null) {
                sink.close();
            }
            this.close();
            throw e;
        }
    }

    public long getSize() {
        return -1L;
    }

    public void abort() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.ftp.close();
        }
        catch (IOException e) {
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (this.state != null) {
                this.state.waitForEnd();
            }
        }
        catch (FTPException e) {
            throw new ChainedIOException("close failed.", e);
        }
        finally {
            try {
                this.ftp.close();
            }
            catch (FTPException ee) {
                throw new ChainedIOException("close failed.", ee);
            }
        }
    }

    public int read(byte[] msg) throws IOException {
        return this.input.read(msg);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.input.read(buf, off, len);
    }

    public int read() throws IOException {
        return this.input.read();
    }

    public int available() throws IOException {
        return this.input.available();
    }
}

