/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy.ext;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.globus.util.I18n;

public class ProxyPolicy
implements DEREncodable {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.proxy.errors", ProxyPolicy.class.getClassLoader());
    public static final DERObjectIdentifier IMPERSONATION = new DERObjectIdentifier("1.3.6.1.5.5.7.21.1");
    public static final DERObjectIdentifier INDEPENDENT = new DERObjectIdentifier("1.3.6.1.5.5.7.21.2");
    public static final DERObjectIdentifier LIMITED = new DERObjectIdentifier("1.3.6.1.4.1.3536.1.1.1.9");
    private DERObjectIdentifier policyLanguage;
    private DEROctetString policy;

    public ProxyPolicy(ASN1Sequence seq) {
        if (seq.size() < 1) {
            throw new IllegalArgumentException(i18n.getMessage("proxyErr30"));
        }
        this.policyLanguage = (DERObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            DEREncodable obj = seq.getObjectAt(1);
            if (obj instanceof DERTaggedObject) {
                obj = ((DERTaggedObject)obj).getObject();
            }
            this.policy = (DEROctetString)obj;
        }
        this.checkConstraints();
    }

    public DERObject getDERObject() {
        DEREncodableVector vec = new DEREncodableVector();
        vec.add((DEREncodable)this.policyLanguage);
        if (this.policy != null) {
            vec.add((DEREncodable)this.policy);
        }
        return new DERSequence(vec);
    }

    public ProxyPolicy(DERObjectIdentifier policyLanguage, byte[] policy) {
        if (policyLanguage == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyErr31"));
        }
        this.policyLanguage = policyLanguage;
        if (policy != null) {
            this.policy = new DEROctetString(policy);
        }
        this.checkConstraints();
    }

    public ProxyPolicy(String policyLanguageOid, byte[] policy) {
        if (policyLanguageOid == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyErr31"));
        }
        this.policyLanguage = new DERObjectIdentifier(policyLanguageOid);
        if (policy != null) {
            this.policy = new DEROctetString(policy);
        }
        this.checkConstraints();
    }

    public ProxyPolicy(DERObjectIdentifier policyLanguage, String policy) {
        this(policyLanguage, policy != null ? policy.getBytes() : null);
    }

    public ProxyPolicy(DERObjectIdentifier policyLanguage) {
        this(policyLanguage, (byte[])null);
    }

    protected void checkConstraints() {
        if ((this.policyLanguage.equals((Object)IMPERSONATION) || this.policyLanguage.equals((Object)INDEPENDENT)) && this.policy != null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyErr32"));
        }
    }

    public byte[] getPolicy() {
        return this.policy != null ? this.policy.getOctets() : null;
    }

    public String getPolicyAsString() {
        return this.policy != null ? new String(this.policy.getOctets()) : null;
    }

    public DERObjectIdentifier getPolicyLanguage() {
        return this.policyLanguage;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProxyPolicy: ");
        buf.append(this.policyLanguage.getId());
        if (this.policy != null) {
            buf.append(System.getProperty("line.separator"));
            buf.append(this.getPolicyAsString());
        }
        return buf.toString();
    }
}

