/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSource;
import org.globus.util.CircularBuffer;

public class OutputStreamDataSource
implements DataSource {
    protected CircularBuffer buffers = new CircularBuffer(5);
    private DataOutputStream out;

    public OutputStreamDataSource(int size) {
        this.out = new DataOutputStream(size);
    }

    public Buffer read() throws IOException {
        try {
            return (Buffer)this.buffers.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public void close() throws IOException {
        this.buffers.interruptBoth();
        this.out.setClosed();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public long totalSize() throws IOException {
        return -1L;
    }

    class DataOutputStream
    extends OutputStream {
        protected byte[] buff;
        protected int index;
        private boolean closed = false;

        public DataOutputStream(int size) {
            this.buff = new byte[size];
            this.index = 0;
        }

        public void write(byte[] data) throws IOException {
            this.write(data, 0, data.length);
        }

        public synchronized void write(byte[] data, int off, int len) throws IOException {
            if (this.isClosed()) {
                throw new EOFException();
            }
            while (len > 0) {
                if (this.index + len > this.buff.length) {
                    int max = this.buff.length - this.index;
                    System.arraycopy(data, off, this.buff, this.index, max);
                    this.index += max;
                    this.flush();
                    len -= max;
                    off += max;
                    continue;
                }
                System.arraycopy(data, off, this.buff, this.index, len);
                this.index += len;
                break;
            }
        }

        public synchronized void write(int b) throws IOException {
            if (this.isClosed()) {
                throw new EOFException();
            }
            if (this.index == this.buff.length) {
                this.flush();
            }
            this.buff[this.index++] = (byte)b;
        }

        public synchronized void flush() throws IOException {
            if (this.index == 0) {
                return;
            }
            byte[] data = new byte[this.index];
            System.arraycopy(this.buff, 0, data, 0, this.index);
            Buffer b = new Buffer(data, this.index);
            try {
                if (!OutputStreamDataSource.this.buffers.put(b)) {
                    throw new EOFException();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            this.index = 0;
        }

        public void close() throws IOException {
            this.flush();
            this.setClosed();
            OutputStreamDataSource.this.buffers.closePut();
        }

        protected synchronized void setClosed() {
            this.closed = true;
        }

        private synchronized boolean isClosed() {
            return this.closed;
        }
    }
}

