/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dcache.utils.Cache;
import org.dcache.utils.CacheElement;
import org.dcache.utils.CacheMXBean;

public class CacheMXBeanImpl<K, V>
implements CacheMXBean<V> {
    private static final Logger _log = Logger.getLogger(CacheMXBeanImpl.class.getName());
    private final Cache<K, V> _cache;

    public CacheMXBeanImpl(Cache<K, V> cache) {
        this._cache = cache;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            String name = String.format("%s:type=Cache,name=%s", this._cache.getClass().getPackage().getName(), this._cache.getName());
            ObjectName mxBeanName = new ObjectName(name);
            if (!server.isRegistered(mxBeanName)) {
                server.registerMBean(this, new ObjectName(name));
            }
        }
        catch (MalformedObjectNameException ex) {
            _log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            _log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (MBeanRegistrationException ex) {
            _log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NotCompliantMBeanException ex) {
            _log.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void clear() {
        this._cache.clear();
    }

    @Override
    public String[] getEntries() {
        List<CacheElement<V>> entries = this._cache.entries();
        String[] asArray = new String[entries.size()];
        int i = 0;
        for (CacheElement<V> v : entries) {
            asArray[i] = v.toString();
            ++i;
        }
        return asArray;
    }

    @Override
    public int getSize() {
        return this._cache.size();
    }

    @Override
    public long getEntryIdleTime() {
        return this._cache.getEntryIdleTime();
    }

    @Override
    public long getEntryLiveTime() {
        return this._cache.getEntryLiveTime();
    }

    @Override
    public long getLastClean() {
        return System.currentTimeMillis() - this._cache.lastClean();
    }
}

