/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.net.InetAddresses;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dcache.util.IPMatcher;

public class Subnet
implements Serializable {
    private static final long serialVersionUID = 9210530422244320383L;
    private static final String ALL_SUBNET = "all";
    private static final int HOST_IP_INDEX = 0;
    private static final int MASK_BITS_INDEX = 1;
    private final InetAddress _subnetAddress;
    private final int _mask;

    protected Subnet() {
        this._subnetAddress = null;
        this._mask = 0;
    }

    protected Subnet(InetAddress subnetAddress, int mask) {
        InetAddress address;
        int hostBits = (subnetAddress instanceof Inet4Address ? 32 : 128) - mask;
        BigInteger maskedAddress = new BigInteger(subnetAddress.getAddress()).shiftRight(hostBits).shiftLeft(hostBits);
        try {
            address = InetAddress.getByAddress(maskedAddress.toByteArray());
        }
        catch (UnknownHostException uhe) {
            address = subnetAddress;
        }
        this._subnetAddress = address;
        this._mask = mask;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Subnet)) {
            return false;
        }
        return other.toString().equals(this.toString());
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this._subnetAddress != null ? this._subnetAddress.hashCode() : 0);
        hash = 53 * hash + this._mask;
        return hash;
    }

    public InetAddress getSubnetAddress() {
        return this._subnetAddress;
    }

    public int getMask() {
        return this._mask;
    }

    public static Subnet create(InetAddress subnetAddress, int mask) {
        return new Subnet(subnetAddress, mask);
    }

    public static Subnet create(String cidrPattern) {
        int cidrMask;
        int maskBitLength;
        if (cidrPattern.equalsIgnoreCase(ALL_SUBNET)) {
            return Subnet.create();
        }
        String[] net_mask = cidrPattern.split("/");
        InetAddress subnetAddress = IPMatcher.convertToIPv4IfPossible(InetAddresses.forString((String)net_mask[0]));
        int n = maskBitLength = subnetAddress instanceof Inet4Address ? 32 : 128;
        if (net_mask.length < 2 || (cidrMask = IPMatcher.convertIPv4MaskStringToCidr(net_mask[1])) == maskBitLength) {
            return Subnet.create(subnetAddress, maskBitLength);
        }
        return Subnet.create(subnetAddress, cidrMask & maskBitLength - 1);
    }

    public static Subnet create() {
        return new Subnet(){

            @Override
            public boolean contains(InetAddress inetAddress) {
                return true;
            }
        };
    }

    public boolean containsHost(String hostname) throws UnknownHostException {
        return this.containsAny(InetAddress.getAllByName(hostname));
    }

    public boolean containsAny(InetAddress[] inetAddresses) {
        for (InetAddress inetAddress : inetAddresses) {
            if (!this.contains(inetAddress)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(InetAddress inetAddress) {
        return IPMatcher.match(inetAddress, this.getSubnetAddress(), this.getMask());
    }

    public String toString() {
        if (this._subnetAddress == null) {
            return ALL_SUBNET;
        }
        if (this._subnetAddress instanceof Inet6Address) {
            return this._subnetAddress.getHostAddress().replaceFirst("(^|:)(0(:|$)){2,}", "::") + "/" + this._mask;
        }
        return this._subnetAddress.getHostAddress() + "/" + this._mask;
    }
}

