/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;

public abstract class NetworkUtils {
    private static final int RANDOM_PORT = 23241;
    private static final int FIRST_CLIENT_HOST = 0;

    public static Comparator<InetAddress> getExternalInternalSorter() {
        return new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress arg0, InetAddress arg1) {
                if (arg0.isLinkLocalAddress() || arg0.isLoopbackAddress() || arg0.isSiteLocalAddress() || arg0.isMulticastAddress()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static List<InetAddress> getLocalAddresses() throws SocketException {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface i = interfaces.nextElement();
            if (!i.isUp() || i.isLoopback()) continue;
            Enumeration<InetAddress> addresses = i.getInetAddresses();
            while (addresses.hasMoreElements()) {
                result.add(addresses.nextElement());
            }
        }
        return result;
    }

    public static List<InetAddress> getLocalAddressesV4() throws SocketException {
        return ImmutableList.copyOf((Collection)Collections2.filter(NetworkUtils.getLocalAddresses(), (Predicate)Predicates.instanceOf(Inet4Address.class)));
    }

    public static InetAddress getLocalAddressForClient(String[] clientHosts) throws SocketException, UnknownHostException {
        InetAddress clientAddress = InetAddress.getByName(clientHosts[0]);
        InetAddress localAddress = NetworkUtils.getLocalAddress(clientAddress);
        return localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalAddress(InetAddress intendedDestination) throws SocketException {
        DatagramSocket socket = new DatagramSocket();
        try {
            socket.connect(intendedDestination, 23241);
            InetAddress inetAddress = socket.getLocalAddress();
            return inetAddress;
        }
        finally {
            socket.close();
        }
    }

    public static URL toURL(URI uri) throws URISyntaxException {
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException e) {
            URISyntaxException exception = new URISyntaxException(uri.toString(), e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        catch (MalformedURLException e) {
            URISyntaxException exception = new URISyntaxException(uri.toString(), e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }
}

