/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

public enum ChecksumType {
    ADLER32(1, "ADLER32"),
    MD5_TYPE(2, "MD5"),
    MD4_TYPE(3, "MD4");

    private final int type;
    private final String name;

    private ChecksumType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public static final ChecksumType getChecksumType(int i) {
        for (ChecksumType type : ChecksumType.values()) {
            if (type.type != i) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checksum type: " + i);
    }

    public static final ChecksumType getChecksumType(String s) {
        for (ChecksumType type : ChecksumType.values()) {
            if (!type.name.equalsIgnoreCase(s) && !String.valueOf(type.type).equals(s)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checksum type: " + s);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

