/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.util;

import org.slf4j.MDC;

public class NDC {
    public static final String KEY_NDC = "org.dcache.ndc";
    public static final String KEY_POSITIONS = "org.dcache.ndc.positions";
    private final String _ndc;
    private final String _positions;

    public NDC(String ndc, String positions) {
        this._ndc = ndc;
        this._positions = positions;
    }

    public String getNdc() {
        return this._ndc;
    }

    public String getPositions() {
        return this._positions;
    }

    private static void setMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    public static void clear() {
        MDC.remove((String)KEY_NDC);
        MDC.remove((String)KEY_POSITIONS);
    }

    public static NDC cloneNdc() {
        return new NDC(MDC.get((String)KEY_NDC), MDC.get((String)KEY_POSITIONS));
    }

    public static void set(NDC ndc) {
        NDC.setMdc(KEY_NDC, ndc.getNdc());
        NDC.setMdc(KEY_POSITIONS, ndc.getPositions());
    }

    public static void push(String message) {
        String ndc = MDC.get((String)KEY_NDC);
        if (ndc == null) {
            MDC.put((String)KEY_NDC, (String)message);
            MDC.put((String)KEY_POSITIONS, (String)"0");
        } else {
            MDC.put((String)KEY_NDC, (String)(ndc + " " + message));
            MDC.put((String)KEY_POSITIONS, (String)(MDC.get((String)KEY_POSITIONS) + "," + ndc.length()));
        }
    }

    public static void pop() {
        String ndc = MDC.get((String)KEY_NDC);
        if (ndc != null) {
            String positions = MDC.get((String)KEY_POSITIONS);
            int pos = positions.lastIndexOf(44);
            if (pos == -1) {
                MDC.remove((String)KEY_NDC);
                MDC.remove((String)KEY_POSITIONS);
            } else {
                int offset = Integer.parseInt(positions.substring(pos + 1));
                MDC.put((String)KEY_NDC, (String)ndc.substring(0, offset));
                MDC.put((String)KEY_POSITIONS, (String)positions.substring(0, pos));
            }
        }
    }
}

