/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.util;

import java.util.Date;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AtomicCounter {
    private final Lock _lock = new ReentrantLock();
    private final Condition _updated = this._lock.newCondition();
    private int _counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        this._lock.lock();
        try {
            ++this._counter;
            this._updated.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get() {
        this._lock.lock();
        try {
            int n = this._counter;
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitChangeUntil(int value, Date deadline) throws InterruptedException {
        this._lock.lock();
        try {
            boolean bl = this._counter != value || this._updated.awaitUntil(deadline);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }
}

