/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats.rrd;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.concurrent.TimeUnit;
import org.dcache.commons.stats.RequestCounter;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RRDRequestCounter {
    private static final long fivemin = TimeUnit.MINUTES.toSeconds(5L);
    private static final long tenmin = TimeUnit.MINUTES.toSeconds(5L);
    private static final long hour = TimeUnit.HOURS.toSeconds(1L);
    private static final long day = TimeUnit.DAYS.toSeconds(1L);
    private static final long month = TimeUnit.DAYS.toSeconds(31L);
    private static final long year = TimeUnit.DAYS.toSeconds(365L);
    private static final int DEFAULT_IMAGE_WIDTH = 491;
    private static final int DEFAULT_IMAGE_HEIGHT = 167;
    private static final Logger logger = LoggerFactory.getLogger(RRDRequestCounter.class);
    private RequestCounter counter;
    private String rrdFileName;
    private String rrdFiveminImage;
    private String rrdHourlyImage;
    private String rrdDaylyImage;
    private String rrdMounthlyImage;
    private String rrdYearlyImage;
    private String rrdGraphicsHtmlFileName;
    private int imageWidth = 491;
    private int imageHeight = 167;
    Long dumpstart;

    public RRDRequestCounter(String rrdDirectory, RequestCounter counter, long updatePeriodSecs) throws IOException {
        this(rrdDirectory, counter, updatePeriodSecs, 491, 167);
    }

    public RRDRequestCounter(String rrdDirectory, RequestCounter counter, long updatePeriodSecs, int imageWidth, int imageHeight) throws IOException {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        if (updatePeriodSecs <= 0L || updatePeriodSecs >= fivemin) {
            throw new IllegalArgumentException("updatePeriodSecs=" + updatePeriodSecs + ", should be greater than 0 and less than " + fivemin + " secs");
        }
        logger.debug("RRDRequestCounter(" + rrdDirectory + ", " + counter + "," + updatePeriodSecs + ")");
        File dir = new File(rrdDirectory);
        if (!(dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new AccessControlException("directory " + rrdDirectory + " does not exists or is not accessable");
        }
        File imagesDir = new File(dir, "images");
        if (!imagesDir.exists()) {
            imagesDir.mkdir();
        }
        if (!(imagesDir.exists() && imagesDir.isDirectory() && imagesDir.canWrite())) {
            throw new AccessControlException("directory " + imagesDir + " does not exists or is not accessable");
        }
        String rrdImageDir = imagesDir.getCanonicalPath();
        String counterName = counter.getName();
        this.rrdFiveminImage = rrdImageDir + File.separatorChar + counterName + ".5min.png";
        this.rrdHourlyImage = rrdImageDir + File.separatorChar + counterName + ".hour.png";
        this.rrdDaylyImage = rrdImageDir + File.separatorChar + counterName + ".day.png";
        this.rrdMounthlyImage = rrdImageDir + File.separatorChar + counterName + ".month.png";
        this.rrdYearlyImage = rrdImageDir + File.separatorChar + counterName + ".year.png";
        File f = new File(dir, counterName + ".rrd4j");
        this.rrdFileName = f.getCanonicalPath();
        if (!f.exists()) {
            RrdDef rrdDef = new RrdDef(this.rrdFileName);
            rrdDef.setStartTime(Util.getTime() - 1L);
            rrdDef.setStep(updatePeriodSecs);
            rrdDef.addDatasource("requests", DsType.DERIVE, updatePeriodSecs * 2L, 0.0, Double.NaN);
            rrdDef.addDatasource("failed", DsType.DERIVE, updatePeriodSecs * 2L, 0.0, Double.NaN);
            int samplesPerOur = (int)(hour / updatePeriodSecs);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, samplesPerOur);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, 1, samplesPerOur);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, 1, samplesPerOur);
            int samplesPerTenMin = (int)(tenmin / updatePeriodSecs);
            int tenMinSamplesPer100Hours = (int)(hour * 100L / (long)samplesPerTenMin);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, samplesPerTenMin, tenMinSamplesPer100Hours);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, samplesPerTenMin, tenMinSamplesPer100Hours);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, samplesPerTenMin, tenMinSamplesPer100Hours);
            int hourSamplesPerMonth = (int)(month / (long)samplesPerOur);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, samplesPerOur, hourSamplesPerMonth);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, samplesPerOur, hourSamplesPerMonth);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, samplesPerOur, hourSamplesPerMonth);
            int samplesPerDay = (int)(24L * hour / updatePeriodSecs);
            int daySamplesPer2Years = (int)(2L * year / (long)samplesPerDay);
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, samplesPerDay, daySamplesPer2Years);
            rrdDef.addArchive(ConsolFun.MIN, 0.5, samplesPerDay, daySamplesPer2Years);
            rrdDef.addArchive(ConsolFun.MAX, 0.5, samplesPerDay, daySamplesPer2Years);
            RrdDb rrdDb = new RrdDb(rrdDef);
            rrdDb.close();
        }
        RrdDb rrdDb = new RrdDb(this.rrdFileName);
        rrdDb.close();
        this.counter = counter;
        File html = new File(rrdDirectory, counterName + ".html");
        if (!html.exists()) {
            String graphicsHtml = RRDRequestCounter.getGraphicsHtml(counterName, imageWidth, imageHeight);
            FileWriter fw = new FileWriter(html);
            fw.write(graphicsHtml);
            fw.close();
        }
        this.rrdGraphicsHtmlFileName = counterName + ".html";
    }

    public void update() throws IOException {
        logger.debug("RRDRequestCounter.update() rrdFileName is " + this.rrdFileName);
        RrdDb rrdDb = new RrdDb(this.rrdFileName);
        Sample sample = rrdDb.createSample();
        long currentTimeSecs = Util.getTime();
        StringBuilder sb = new StringBuilder();
        sb.append(currentTimeSecs).append(':');
        sb.append(this.counter.getTotalRequests()).append(':');
        sb.append(this.counter.getFailed());
        sample.setAndUpdate(sb.toString());
        logger.debug("RRDRequestCounter.update() updated with : " + sb.toString());
        rrdDb.close();
        logger.debug("RRDRequestCounter.update() succeeded");
        logger.debug("RRDRequestCounter.update() let us try to fetch data");
        rrdDb = new RrdDb(this.rrdFileName);
        if (this.dumpstart == null) {
            this.dumpstart = currentTimeSecs - 100L;
        }
        FetchRequest fetchRequest = rrdDb.createFetchRequest(ConsolFun.AVERAGE, this.dumpstart.longValue(), currentTimeSecs + 1L);
        FetchData fetchData = fetchRequest.fetchData();
        logger.debug("RRDRequestCounter.update() dump is: " + fetchData.dump());
        rrdDb.close();
    }

    public void graph() throws IOException {
        long currentTime = Util.getTime();
        logger.debug("RRDRequestCounter.graph()");
        RrdDb rrdDb = new RrdDb(this.rrdFileName);
        RrdGraphDef graphDef = new RrdGraphDef();
        graphDef.setVerticalLabel("requests/sec");
        graphDef.setUnit("r");
        graphDef.datasource("requests_avg", this.rrdFileName, "requests", ConsolFun.AVERAGE);
        graphDef.datasource("failed_avg", this.rrdFileName, "failed", ConsolFun.AVERAGE);
        graphDef.line("requests_avg", (Paint)new Color(187, 0, 0), "requests_avg", 4.0f);
        graphDef.line("failed_avg", (Paint)new Color(0, 187, 0), "failed_avg", 4.0f);
        graphDef.datasource("requests_max", this.rrdFileName, "requests", ConsolFun.MAX);
        graphDef.datasource("failed_max", this.rrdFileName, "failed", ConsolFun.MAX);
        graphDef.line("requests_max", (Paint)new Color(255, 0, 0), "requests_max", 3.0f);
        graphDef.line("failed_max", (Paint)new Color(0, 255, 0), "failed_max", 3.0f);
        graphDef.datasource("requests_min", this.rrdFileName, "requests", ConsolFun.MIN);
        graphDef.datasource("failed_min", this.rrdFileName, "failed", ConsolFun.MIN);
        graphDef.line("requests_min", (Paint)new Color(144, 32, 32), "requests_min", 2.0f);
        graphDef.line("failed_min", (Paint)new Color(32, 144, 32), "failed_min", 2.0f);
        graphDef.setTimeSpan(currentTime - fivemin, currentTime);
        graphDef.setFilename(this.rrdFiveminImage);
        RrdGraph graph = new RrdGraph(graphDef);
        BufferedImage bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        graph.render(bi.getGraphics());
        logger.debug("RRDRequestCounter.graph() wrote " + this.rrdHourlyImage);
        graphDef.setTimeSpan(currentTime - hour, currentTime);
        graphDef.setFilename(this.rrdHourlyImage);
        graph = new RrdGraph(graphDef);
        bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        graph.render(bi.getGraphics());
        logger.debug("RRDRequestCounter.graph() wrote " + this.rrdHourlyImage);
        graphDef.setTimeSpan(currentTime - day, currentTime);
        graphDef.setFilename(this.rrdDaylyImage);
        graph = new RrdGraph(graphDef);
        bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        graph.render(bi.getGraphics());
        graphDef.setTimeSpan(currentTime - month, currentTime);
        graphDef.setFilename(this.rrdMounthlyImage);
        graph = new RrdGraph(graphDef);
        bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        graph.render(bi.getGraphics());
        graphDef.setTimeSpan(currentTime - year, currentTime);
        graphDef.setFilename(this.rrdYearlyImage);
        graph = new RrdGraph(graphDef);
        bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        graph.render(bi.getGraphics());
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHight() {
        return this.imageHeight;
    }

    public void setImageHight(int imageHight) {
        this.imageHeight = imageHight;
    }

    private static final String getGraphicsHtml(String counterName, int width, int height) {
        StringBuilder sb = new StringBuilder("\"width: ");
        sb.append(width);
        sb.append("px; height: ");
        sb.append(height);
        sb.append("px;\"");
        String style = sb.toString();
        sb = new StringBuilder();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("  <meta content=\"text/html; charset=ISO-8859-1\"\n");
        sb.append(" http-equiv=\"content-type\">\n");
        sb.append(" <title>Request Rate Graphics for ");
        sb.append(counterName);
        sb.append("</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<h1> Request Rate Graphics for ");
        sb.append(counterName);
        sb.append("</h1> \n");
        sb.append("5 Minutes<br>\n");
        sb.append("<img style=");
        sb.append(style);
        sb.append(" alt=\"5 Minutes\"\n");
        sb.append(" src=\"images/");
        sb.append(counterName);
        sb.append(".5min.png\"><br>\n");
        sb.append("Hour<br>\n");
        sb.append("<img style=");
        sb.append(style);
        sb.append(" alt=\"Hour\"\n");
        sb.append(" src=\"images/");
        sb.append(counterName);
        sb.append(".hour.png\"><br>\n");
        sb.append("Day<br>\n");
        sb.append("<img style=");
        sb.append(style);
        sb.append(" alt=\"Day\"\n");
        sb.append(" src=\"images/");
        sb.append(counterName);
        sb.append(".day.png\"><br>\n");
        sb.append("Month<br>\n");
        sb.append("<img style=");
        sb.append(style);
        sb.append(" alt=\"Month\"\n");
        sb.append(" src=\"images/");
        sb.append(counterName);
        sb.append(".month.png\"><br>\n");
        sb.append("Year<br>\n");
        sb.append("<img style=");
        sb.append(style);
        sb.append(" alt=\"Year\"\n");
        sb.append(" src=\"images/");
        sb.append(counterName);
        sb.append(".year.png\"><br>\n");
        sb.append("</body>\n");
        sb.append("</html>");
        return sb.toString();
    }

    public String getRrdGraphicsHtmlFileName() {
        return this.rrdGraphicsHtmlFileName;
    }

    public String getName() {
        return this.counter.getName();
    }
}

