/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dcache.commons.stats.RequestExecutionTimeGauge;

public class RequestExecutionTimeGauges<T> {
    private final String name;
    private final boolean autoCreate;
    private final Map<T, RequestExecutionTimeGauge> gauges = new HashMap<T, RequestExecutionTimeGauge>();

    public RequestExecutionTimeGauges(String name) {
        this(name, true);
    }

    public RequestExecutionTimeGauges(String name, boolean autoCreate) {
        this.name = name;
        this.autoCreate = autoCreate;
    }

    public String getName() {
        return this.name;
    }

    public void addGauge(T key) {
        String gaugeName;
        if (key instanceof Class) {
            Class ckey = (Class)key;
            gaugeName = ckey.getSimpleName();
        } else if (key instanceof Method) {
            Method mkey = (Method)key;
            StringBuilder sb = new StringBuilder();
            sb.append(mkey.getName());
            sb.append("( ");
            for (Class<?> mParmType : mkey.getParameterTypes()) {
                sb.append(mParmType.getSimpleName());
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            gaugeName = sb.toString();
        } else {
            gaugeName = key.toString();
        }
        this.addGauge(key, gaugeName);
    }

    public synchronized void addGauge(T key, String name) {
        if (this.gauges.containsKey(key)) {
            return;
        }
        RequestExecutionTimeGauge gauge = new RequestExecutionTimeGauge(name);
        this.gauges.put(key, gauge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%-36s %23s %12s %12s %12s %12s %12s", this.name, "average\u00b1stderr(ms)", "min(ms)", "max(ms)", "STD(ms)", "Sampes", "SampingPeriod(ms)");
        formatter.flush();
        formatter.close();
        RequestExecutionTimeGauges requestExecutionTimeGauges = this;
        synchronized (requestExecutionTimeGauges) {
            for (T key : this.gauges.keySet()) {
                RequestExecutionTimeGauge gauge = this.gauges.get(key);
                sb.append("\n  ").append(gauge);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String gaugeToString(T gaugeKey) {
        RequestExecutionTimeGauge gauge;
        RequestExecutionTimeGauges requestExecutionTimeGauges = this;
        synchronized (requestExecutionTimeGauges) {
            gauge = this.gauges.get(gaugeKey);
        }
        if (gauge == null) {
            throw new NoSuchElementException("gauge for key  " + gaugeKey + " is not defined in " + this.name + " counters");
        }
        return gauge.toString();
    }

    public RequestExecutionTimeGauge getGauge(T gaugeKey) {
        RequestExecutionTimeGauges requestExecutionTimeGauges = this;
        synchronized (requestExecutionTimeGauges) {
            if (this.gauges.containsKey(gaugeKey)) {
                return this.gauges.get(gaugeKey);
            }
            if (this.autoCreate) {
                this.addGauge(gaugeKey);
                return this.gauges.get(gaugeKey);
            }
            throw new NoSuchElementException("gauge with name " + gaugeKey + " is not defined in " + this.name + " guages");
        }
    }

    public long getAverageExecutionTime(T gaugeKey) {
        return this.getGauge(gaugeKey).getAverageExecutionTime();
    }

    public void update(T gaugeKey, long nextExecTime) {
        this.getGauge(gaugeKey).update(nextExecTime);
    }

    public Set<T> keySet() {
        return this.gauges.keySet();
    }
}

